/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="order_1")
public final class Order
implements xuml.tools.model.compiler.runtime.Entity<Order> {
    private static volatile BehaviourFactory _behaviourFactory;
    @Transient
    private Behaviour _behaviour;
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="order_id", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="date_order_placed", nullable=true)
    @Temporal(value=TemporalType.DATE)
    private volatile Date dateOrderPlaced = new Date(0L);
    @Column(name="recipient", nullable=true, length=512)
    private volatile String recipient = new String("");
    @Column(name="delivery_address", nullable=true, length=512)
    private volatile String deliveryAddress = new String("");
    @Column(name="contact_phone", nullable=true, length=256)
    private volatile String contactPhone = new String("");
    @Column(name="state", nullable=false)
    private volatile String state;

    public Order() {
        this._behaviour = _behaviourFactory.create(this);
    }

    public static void setBehaviourFactory(BehaviourFactory factory) {
        _behaviourFactory = factory;
    }

    public static void setBehaviourFactory(Class<? extends Behaviour> cls) {
        _behaviourFactory = Order.createBehaviourFactory(cls);
    }

    public static BehaviourFactory getBehaviourFactory() {
        return _behaviourFactory;
    }

    public Order(Integer id) {
        this.id = id;
    }

    public static Order create(Integer id) {
        return new Order(id);
    }

    public static Order create(CreationEvent<Order> creationEvent) {
        return Context.create(Order.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return Order.class.getName() + ":" + this.getId();
    }

    private void validateDateOrderPlaced() {
    }

    private void validateRecipient() {
        if (this.recipient == null || this.recipient.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.recipient == null || !this.recipient.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.recipient == null || !this.recipient.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.recipient == null || !Pattern.matches(".*", this.recipient)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateDeliveryAddress() {
        if (this.deliveryAddress == null || this.deliveryAddress.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.deliveryAddress == null || !this.deliveryAddress.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.deliveryAddress == null || !this.deliveryAddress.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.deliveryAddress == null || !Pattern.matches(".*", this.deliveryAddress)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateContactPhone() {
        if (this.contactPhone == null || this.contactPhone.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.contactPhone == null || !this.contactPhone.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.contactPhone == null || !this.contactPhone.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.contactPhone == null || !Pattern.matches(".*", this.contactPhone)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateContactPhone();
        this.validateDateOrderPlaced();
        this.validateDeliveryAddress();
        this.validateRecipient();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateContactPhone();
        this.validateDateOrderPlaced();
        this.validateDeliveryAddress();
        this.validateRecipient();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getDateOrderPlaced() {
        return this.dateOrderPlaced;
    }

    public void setDateOrderPlaced(Date dateOrderPlaced) {
        this.dateOrderPlaced = dateOrderPlaced;
    }

    public Order setDateOrderPlaced_(Date dateOrderPlaced) {
        this.setDateOrderPlaced(dateOrderPlaced);
        return this;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public Order setRecipient_(String recipient) {
        this.setRecipient(recipient);
        return this;
    }

    public String getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public Order setDeliveryAddress_(String deliveryAddress) {
        this.setDeliveryAddress(deliveryAddress);
        return this;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public Order setContactPhone_(String contactPhone) {
        this.setContactPhone(contactPhone);
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Order signal(Event<Order> event) {
        this.helper().signal(event);
        return this;
    }

    public Order signal(Event<Order> event, Duration delay) {
        this.helper().signal(event, Optional.of((Object)delay));
        return this;
    }

    public Order signal(Event<Order> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public Order cancelSignal(String eventSignatureKey) {
        return this;
    }

    public Order cancelSignal(Event<Order> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public Order event(Event<Order> event) {
        this.helper().beforeEvent();
        if (event instanceof Events.CheckOut) {
            this.processEvent((Events.CheckOut)event);
        } else if (event instanceof Events.SubmitCharge) {
            this.processEvent((Events.SubmitCharge)event);
        } else if (event instanceof Events.PaymentDeclined) {
            this.processEvent((Events.PaymentDeclined)event);
        } else if (event instanceof Events.PaymentApproved) {
            this.processEvent((Events.PaymentApproved)event);
        } else if (event instanceof Events.OrderDelivered) {
            this.processEvent((Events.OrderDelivered)event);
        }
        this.helper().afterEvent();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Events.CheckOut event) {
        if (this.state == null) {
            this.state = State.ESTABLISHING_CUSTOMER_AND_VERIFYING_PAYMENT.toString();
            Order order = this;
            synchronized (order) {
                this._behaviour.onEntryEstablishingCustomerAndVerifyingPayment(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Events.SubmitCharge event) {
        if (this.state.equals(State.ESTABLISHING_CUSTOMER_AND_VERIFYING_PAYMENT.toString())) {
            this.state = State.MAKING_CHARGE.toString();
            Order order = this;
            synchronized (order) {
                this._behaviour.onEntryMakingCharge(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Events.PaymentDeclined event) {
        if (this.state.equals(State.MAKING_CHARGE.toString())) {
            this.state = State.PAYMENT_NOT_APPROVED.toString();
            Order order = this;
            synchronized (order) {
                this._behaviour.onEntryPaymentNotApproved(event);
            }
        }
    }

    private void processEvent(Events.PaymentApproved event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Events.OrderDelivered event) {
        if (this.state.equals(State.MAKING_CHARGE.toString())) {
            this.state = State.BEING_PACKED_AND_SHIPPED.toString();
            Order order = this;
            synchronized (order) {
                this._behaviour.onEntryBeingPackedAndShipped(event);
            }
        }
    }

    public static Order create(EntityManager em, CreationEvent<Order> event) {
        Order entity = new Order();
        entity.event((Event)event);
        em.persist((Object)entity);
        return entity;
    }

    public Order merge(EntityManager em) {
        return (Order)em.merge((Object)this);
    }

    public Order persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public Order remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public Order remove() {
        Context.remove(this);
        return this;
    }

    public Order delete() {
        return this.remove();
    }

    public Order refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public Order load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public Order load() {
        return Context.load(this);
    }

    public static BehaviourFactory createBehaviourFactory(final Class<? extends Behaviour> cls) {
        return new BehaviourFactory(){

            @Override
            public Behaviour create(Order entity) {
                if (cls.getConstructors().length != 1) {
                    throw new RuntimeException("expected only one constructor in the Behaviour implementation");
                }
                try {
                    return (Behaviour)cls.getConstructors()[0].newInstance(entity);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Order> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(Order.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            Order result = (Order)em.find(Order.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<Order> select(BooleanExpression<Order> where) {
        return new SelectBuilder(where).entityClass(Order.class).info(signaller.getInfo());
    }

    public static SelectBuilder<Order> select() {
        return Order.select(null);
    }

    public static class Attribute {
        public static final StringExpressionField<Order> dateOrderPlaced = new StringExpressionField(new Field("dateOrderPlaced"));
        public static final StringExpressionField<Order> recipient = new StringExpressionField(new Field("recipient"));
        public static final StringExpressionField<Order> deliveryAddress = new StringExpressionField(new Field("deliveryAddress"));
        public static final StringExpressionField<Order> contactPhone = new StringExpressionField(new Field("contactPhone"));
        public static final NumericExpressionField<Order> id = new NumericExpressionField(new Field("id.id"));
    }

    public static interface BehaviourFactory {
        public Behaviour create(Order var1);
    }

    public static interface Behaviour {
        public void onEntryEstablishingCustomerAndVerifyingPayment(Events.CheckOut var1);

        public void onEntryMakingCharge(Events.SubmitCharge var1);

        public void onEntryPaymentNotApproved(Events.PaymentDeclined var1);

        public void onEntryBeingPackedAndShipped(Events.OrderDelivered var1);
    }

    public static class Events {

        public static class OrderDelivered
        implements Event<Order>,
        Serializable {
            public static final String signatureKey = "";

            public String signatureKey() {
                return signatureKey;
            }

            public OrderDelivered() {
            }

            private OrderDelivered(Builder builder) {
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                public OrderDelivered build() {
                    return new OrderDelivered(this);
                }
            }
        }

        public static class PaymentApproved
        implements Event<Order>,
        Serializable {
            public static final String signatureKey = "";

            public String signatureKey() {
                return signatureKey;
            }

            public PaymentApproved() {
            }

            private PaymentApproved(Builder builder) {
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                public PaymentApproved build() {
                    return new PaymentApproved(this);
                }
            }
        }

        public static class PaymentDeclined
        implements Event<Order>,
        Serializable {
            public static final String signatureKey = "";

            public String signatureKey() {
                return signatureKey;
            }

            public PaymentDeclined() {
            }

            private PaymentDeclined(Builder builder) {
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                public PaymentDeclined build() {
                    return new PaymentDeclined(this);
                }
            }
        }

        public static class SubmitCharge
        implements Event<Order>,
        Serializable {
            public static final String signatureKey = "java.lang.Integer;java.lang.String;java.lang.String;java.lang.String;java.lang.String;";
            private final Integer cart;
            private final String accountNumber;
            private final String billingAddress;
            private final String cardExpirationDate;
            private final String cardholderName;

            public String signatureKey() {
                return signatureKey;
            }

            public SubmitCharge(Integer cart, String accountNumber, String billingAddress, String cardExpirationDate, String cardholderName) {
                this.cart = cart;
                this.accountNumber = accountNumber;
                this.billingAddress = billingAddress;
                this.cardExpirationDate = cardExpirationDate;
                this.cardholderName = cardholderName;
            }

            public Integer getCart() {
                return this.cart;
            }

            public String getAccountNumber() {
                return this.accountNumber;
            }

            public String getBillingAddress() {
                return this.billingAddress;
            }

            public String getCardExpirationDate() {
                return this.cardExpirationDate;
            }

            public String getCardholderName() {
                return this.cardholderName;
            }

            private SubmitCharge(Builder builder) {
                this.cart = builder.cart;
                this.accountNumber = builder.accountNumber;
                this.billingAddress = builder.billingAddress;
                this.cardExpirationDate = builder.cardExpirationDate;
                this.cardholderName = builder.cardholderName;
            }

            public static Builder builder() {
                return new Builder();
            }

            public String toString() {
                return MoreObjects.toStringHelper(this.getClass()).add("cart", (Object)this.cart).add("accountNumber", (Object)this.accountNumber).add("billingAddress", (Object)this.billingAddress).add("cardExpirationDate", (Object)this.cardExpirationDate).add("cardholderName", (Object)this.cardholderName).toString();
            }

            public static class Builder {
                private Integer cart;
                private String accountNumber;
                private String billingAddress;
                private String cardExpirationDate;
                private String cardholderName;

                public Builder cart(Integer cart) {
                    this.cart = cart;
                    return this;
                }

                public Builder accountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder billingAddress(String billingAddress) {
                    this.billingAddress = billingAddress;
                    return this;
                }

                public Builder cardExpirationDate(String cardExpirationDate) {
                    this.cardExpirationDate = cardExpirationDate;
                    return this;
                }

                public Builder cardholderName(String cardholderName) {
                    this.cardholderName = cardholderName;
                    return this;
                }

                public SubmitCharge build() {
                    return new SubmitCharge(this);
                }
            }
        }

        public static class CheckOut
        implements Event<Order>,
        Serializable,
        CreationEvent<Order> {
            public static final String signatureKey = "java.lang.Integer;java.lang.String;java.lang.String;java.lang.String;java.lang.String;java.lang.String;java.lang.String;java.lang.String;java.lang.String;";
            private final Integer cart;
            private final String accountNumber;
            private final String billingAddress;
            private final String cardExpirationDate;
            private final String cardholderName;
            private final String customerEmail;
            private final String customerName;
            private final String customerPhone;
            private final String shippingAddress;

            public String signatureKey() {
                return signatureKey;
            }

            public CheckOut(Integer cart, String accountNumber, String billingAddress, String cardExpirationDate, String cardholderName, String customerEmail, String customerName, String customerPhone, String shippingAddress) {
                this.cart = cart;
                this.accountNumber = accountNumber;
                this.billingAddress = billingAddress;
                this.cardExpirationDate = cardExpirationDate;
                this.cardholderName = cardholderName;
                this.customerEmail = customerEmail;
                this.customerName = customerName;
                this.customerPhone = customerPhone;
                this.shippingAddress = shippingAddress;
            }

            public Integer getCart() {
                return this.cart;
            }

            public String getAccountNumber() {
                return this.accountNumber;
            }

            public String getBillingAddress() {
                return this.billingAddress;
            }

            public String getCardExpirationDate() {
                return this.cardExpirationDate;
            }

            public String getCardholderName() {
                return this.cardholderName;
            }

            public String getCustomerEmail() {
                return this.customerEmail;
            }

            public String getCustomerName() {
                return this.customerName;
            }

            public String getCustomerPhone() {
                return this.customerPhone;
            }

            public String getShippingAddress() {
                return this.shippingAddress;
            }

            private CheckOut(Builder builder) {
                this.cart = builder.cart;
                this.accountNumber = builder.accountNumber;
                this.billingAddress = builder.billingAddress;
                this.cardExpirationDate = builder.cardExpirationDate;
                this.cardholderName = builder.cardholderName;
                this.customerEmail = builder.customerEmail;
                this.customerName = builder.customerName;
                this.customerPhone = builder.customerPhone;
                this.shippingAddress = builder.shippingAddress;
            }

            public static Builder builder() {
                return new Builder();
            }

            public String toString() {
                return MoreObjects.toStringHelper(this.getClass()).add("cart", (Object)this.cart).add("accountNumber", (Object)this.accountNumber).add("billingAddress", (Object)this.billingAddress).add("cardExpirationDate", (Object)this.cardExpirationDate).add("cardholderName", (Object)this.cardholderName).add("customerEmail", (Object)this.customerEmail).add("customerName", (Object)this.customerName).add("customerPhone", (Object)this.customerPhone).add("shippingAddress", (Object)this.shippingAddress).toString();
            }

            public static class Builder {
                private Integer cart;
                private String accountNumber;
                private String billingAddress;
                private String cardExpirationDate;
                private String cardholderName;
                private String customerEmail;
                private String customerName;
                private String customerPhone;
                private String shippingAddress;

                public Builder cart(Integer cart) {
                    this.cart = cart;
                    return this;
                }

                public Builder accountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder billingAddress(String billingAddress) {
                    this.billingAddress = billingAddress;
                    return this;
                }

                public Builder cardExpirationDate(String cardExpirationDate) {
                    this.cardExpirationDate = cardExpirationDate;
                    return this;
                }

                public Builder cardholderName(String cardholderName) {
                    this.cardholderName = cardholderName;
                    return this;
                }

                public Builder customerEmail(String customerEmail) {
                    this.customerEmail = customerEmail;
                    return this;
                }

                public Builder customerName(String customerName) {
                    this.customerName = customerName;
                    return this;
                }

                public Builder customerPhone(String customerPhone) {
                    this.customerPhone = customerPhone;
                    return this;
                }

                public Builder shippingAddress(String shippingAddress) {
                    this.shippingAddress = shippingAddress;
                    return this;
                }

                public CheckOut build() {
                    return new CheckOut(this);
                }
            }
        }
    }

    public static enum State {
        ESTABLISHING_CUSTOMER_AND_VERIFYING_PAYMENT,
        MAKING_CHARGE,
        BEING_PACKED_AND_SHIPPED,
        PAYMENT_NOT_APPROVED,
        DELIVERED_TO_CUSTOMER;

    }
}

