/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import bookstore.ProductCategory;
import bookstore.Publisher;
import bookstore.SpecialOrderProduct;
import bookstore.StockedProduct;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.RelationshipNotEstablishedException;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.TooManySpecializationsException;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="product")
public final class Product
implements xuml.tools.model.compiler.runtime.Entity<Product> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="product_id", nullable=false, length=64)
    private volatile String id = new String("");
    @Column(name="copyright", nullable=true)
    private volatile Integer copyright = new Integer("0");
    private static final BigDecimal COPYRIGHT_UPPER_LIMIT;
    private static final BigDecimal COPYRIGHT_LOWER_LIMIT;
    @Column(name="unit_price", nullable=true, precision=2)
    private volatile Double unitPrice = new Double("0");
    private static final BigDecimal UNITPRICE_UPPER_LIMIT;
    private static final BigDecimal UNITPRICE_LOWER_LIMIT;
    @Column(name="description", nullable=true, length=4096)
    private volatile String description = new String("");
    @Column(name="website", nullable=true, length=2000)
    private volatile String website = new String("");
    @ManyToOne(targetEntity=Publisher.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="publisher_code", referencedColumnName="publisher_code", nullable=false, insertable=true, updatable=true), @JoinColumn(name="publisher_group_code", referencedColumnName="group_code", nullable=false, insertable=true, updatable=true)})
    private Publisher publisher_R1;
    @ManyToOne(targetEntity=ProductCategory.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="category_id", referencedColumnName="category_id", nullable=false, insertable=true, updatable=true)})
    private ProductCategory productCategory_R15;
    @OneToOne(mappedBy="product_R12", fetch=FetchType.LAZY, targetEntity=StockedProduct.class)
    private StockedProduct stockedProduct_R12;
    @OneToOne(mappedBy="product_R12", fetch=FetchType.LAZY, targetEntity=SpecialOrderProduct.class)
    private SpecialOrderProduct specialOrderProduct_R12;

    public Product() {
    }

    public Product(String id) {
        this.id = id;
    }

    public static Product create(String id) {
        return new Product(id);
    }

    public static Product create(CreationEvent<Product> creationEvent) {
        return Context.create(Product.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return Product.class.getName() + ":" + this.getId();
    }

    private void validateCopyright() {
        if (COPYRIGHT_UPPER_LIMIT.doubleValue() < (double)this.copyright.intValue()) {
            throw new ValidationException("upper limit of 2100 failed");
        }
        if (COPYRIGHT_LOWER_LIMIT.doubleValue() > (double)this.copyright.intValue()) {
            throw new ValidationException("lower limit of -5000 failed");
        }
    }

    private void validateUnitPrice() {
        if (UNITPRICE_UPPER_LIMIT.doubleValue() < this.unitPrice) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (UNITPRICE_LOWER_LIMIT.doubleValue() > this.unitPrice) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    private void validateDescription() {
        if (this.description == null || this.description.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.description == null || !this.description.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.description == null || !this.description.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.description == null || !Pattern.matches(".*", this.description)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateWebsite() {
        if (this.website == null || this.website.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.website == null || !this.website.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.website == null || !this.website.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.website == null || !Pattern.matches(".*", this.website)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    public Publisher getPublisher_R1() {
        return this.publisher_R1;
    }

    public void setPublisher_R1(Publisher publisher_R1) {
        this.publisher_R1 = publisher_R1;
    }

    public Product relateAcrossR1(Publisher publisher_R1) {
        this.setPublisher_R1(publisher_R1);
        publisher_R1.getProduct_R1().add(this);
        return this;
    }

    public Product unrelateAcrossR1(Publisher publisher_R1) {
        this.setPublisher_R1(null);
        publisher_R1.getProduct_R1().remove(this);
        return this;
    }

    public ProductCategory getProductCategory_R15() {
        return this.productCategory_R15;
    }

    public void setProductCategory_R15(ProductCategory productCategory_R15) {
        this.productCategory_R15 = productCategory_R15;
    }

    public Product relateAcrossR15(ProductCategory productCategory_R15) {
        this.setProductCategory_R15(productCategory_R15);
        productCategory_R15.getProduct_R15().add(this);
        return this;
    }

    public Product unrelateAcrossR15(ProductCategory productCategory_R15) {
        this.setProductCategory_R15(null);
        productCategory_R15.getProduct_R15().remove(this);
        return this;
    }

    public StockedProduct getStockedProduct_R12() {
        return this.stockedProduct_R12;
    }

    public void setStockedProduct_R12(StockedProduct stockedProduct_R12) {
        this.stockedProduct_R12 = stockedProduct_R12;
    }

    public Product relateAcrossR12(StockedProduct stockedProduct_R12) {
        this.setStockedProduct_R12(stockedProduct_R12);
        stockedProduct_R12.setProduct_R12(this);
        return this;
    }

    public Product unrelateAcrossR12(StockedProduct stockedProduct_R12) {
        this.setStockedProduct_R12(null);
        stockedProduct_R12.setProduct_R12(null);
        return this;
    }

    public SpecialOrderProduct getSpecialOrderProduct_R12() {
        return this.specialOrderProduct_R12;
    }

    public void setSpecialOrderProduct_R12(SpecialOrderProduct specialOrderProduct_R12) {
        this.specialOrderProduct_R12 = specialOrderProduct_R12;
    }

    public Product relateAcrossR12(SpecialOrderProduct specialOrderProduct_R12) {
        this.setSpecialOrderProduct_R12(specialOrderProduct_R12);
        specialOrderProduct_R12.setProduct_R12(this);
        return this;
    }

    public Product unrelateAcrossR12(SpecialOrderProduct specialOrderProduct_R12) {
        this.setSpecialOrderProduct_R12(null);
        specialOrderProduct_R12.setProduct_R12(null);
        return this;
    }

    private void validateSpecializationR12() {
        int count = 0;
        if (this.specialOrderProduct_R12 != null) {
            ++count;
        }
        if (this.stockedProduct_R12 != null) {
            ++count;
        }
        if (count == 0) {
            throw new RelationshipNotEstablishedException("wrong number of specializations = " + count);
        }
        if (count != 1) {
            throw new TooManySpecializationsException("wrong number of specializations = " + count);
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateCopyright();
        this.validateDescription();
        this.validateSpecializationR12();
        this.validateUnitPrice();
        this.validateWebsite();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateCopyright();
        this.validateDescription();
        this.validateSpecializationR12();
        this.validateUnitPrice();
        this.validateWebsite();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCopyright() {
        return this.copyright;
    }

    public void setCopyright(Integer copyright) {
        this.copyright = copyright;
    }

    public Product setCopyright_(Integer copyright) {
        this.setCopyright(copyright);
        return this;
    }

    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Product setUnitPrice_(Double unitPrice) {
        this.setUnitPrice(unitPrice);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Product setDescription_(String description) {
        this.setDescription(description);
        return this;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Product setWebsite_(String website) {
        this.setWebsite(website);
        return this;
    }

    public Product signal(Event<Product> event) {
        return this;
    }

    public Product signal(Event<Product> event, Duration delay) {
        return this;
    }

    public Product signal(Event<Product> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public Product cancelSignal(String eventSignatureKey) {
        return this;
    }

    public Product cancelSignal(Event<Product> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public Product event(Event<Product> event) {
        return this;
    }

    public Product merge(EntityManager em) {
        return (Product)em.merge((Object)this);
    }

    public Product persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public Product remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public Product remove() {
        Context.remove(this);
        return this;
    }

    public Product delete() {
        return this.remove();
    }

    public Product refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public Product load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public Product load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Product> find(String id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(Product.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            Product result = (Product)em.find(Product.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<Product> select(BooleanExpression<Product> where) {
        return new SelectBuilder(where).entityClass(Product.class).info(signaller.getInfo());
    }

    public static SelectBuilder<Product> select() {
        return Product.select(null);
    }

    static {
        COPYRIGHT_UPPER_LIMIT = new BigDecimal("2100");
        COPYRIGHT_LOWER_LIMIT = new BigDecimal("-5000");
        UNITPRICE_UPPER_LIMIT = new BigDecimal("999999999999");
        UNITPRICE_LOWER_LIMIT = new BigDecimal("0");
    }

    public static class Attribute {
        public static final NumericExpressionField<Product> copyright = new NumericExpressionField(new Field("copyright"));
        public static final NumericExpressionField<Product> unitPrice = new NumericExpressionField(new Field("unitPrice"));
        public static final StringExpressionField<Product> description = new StringExpressionField(new Field("description"));
        public static final StringExpressionField<Product> website = new StringExpressionField(new Field("website"));
        public static final StringExpressionField<Product> id = new StringExpressionField(new Field("id.id"));
    }
}

