/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import bookstore.Product;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="product_category")
public final class ProductCategory
implements xuml.tools.model.compiler.runtime.Entity<ProductCategory> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="category_id", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="category_name", nullable=true, length=4096)
    private volatile String categoryName = new String("");
    @OneToOne(targetEntity=ProductCategory.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="category_id", referencedColumnName="category_id_r14", nullable=true, insertable=true, updatable=true)})
    private ProductCategory isPartOf_R14;
    @OneToOne(targetEntity=ProductCategory.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="category_id_r14", referencedColumnName="category_id", nullable=true, insertable=true, updatable=true)})
    private ProductCategory isPartOfInverse_R14;
    @OneToMany(mappedBy="productCategory_R15", cascade={CascadeType.MERGE, CascadeType.REFRESH, CascadeType.REMOVE}, fetch=FetchType.LAZY, targetEntity=Product.class)
    private Set<Product> product_R15 = Sets.newHashSet();

    public ProductCategory() {
    }

    public ProductCategory(Integer id) {
        this.id = id;
    }

    public static ProductCategory create(Integer id) {
        return new ProductCategory(id);
    }

    public static ProductCategory create(CreationEvent<ProductCategory> creationEvent) {
        return Context.create(ProductCategory.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return ProductCategory.class.getName() + ":" + this.getId();
    }

    private void validateCategoryName() {
        if (this.categoryName == null || this.categoryName.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.categoryName == null || !this.categoryName.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.categoryName == null || !this.categoryName.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.categoryName == null || !Pattern.matches(".*", this.categoryName)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    public ProductCategory getIsPartOf_R14() {
        return this.isPartOf_R14;
    }

    public void setIsPartOf_R14(ProductCategory isPartOf_R14) {
        this.isPartOf_R14 = isPartOf_R14;
    }

    public ProductCategory getIsPartOfInverse_R14() {
        return this.isPartOfInverse_R14;
    }

    public void setIsPartOfInverse_R14(ProductCategory isPartOfInverse_R14) {
        this.isPartOfInverse_R14 = isPartOfInverse_R14;
    }

    public Set<Product> getProduct_R15() {
        return this.product_R15;
    }

    public void setProduct_R15(Set<Product> product_R15) {
        this.product_R15 = product_R15;
    }

    public ProductCategory relateAcrossR15(Product product_R15) {
        this.getProduct_R15().add(product_R15);
        product_R15.setProductCategory_R15(this);
        return this;
    }

    public ProductCategory unrelateAcrossR15(Product product_R15) {
        this.getProduct_R15().remove(product_R15);
        product_R15.setProductCategory_R15(null);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateCategoryName();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateCategoryName();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public ProductCategory setCategoryName_(String categoryName) {
        this.setCategoryName(categoryName);
        return this;
    }

    public ProductCategory signal(Event<ProductCategory> event) {
        return this;
    }

    public ProductCategory signal(Event<ProductCategory> event, Duration delay) {
        return this;
    }

    public ProductCategory signal(Event<ProductCategory> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public ProductCategory cancelSignal(String eventSignatureKey) {
        return this;
    }

    public ProductCategory cancelSignal(Event<ProductCategory> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public ProductCategory event(Event<ProductCategory> event) {
        return this;
    }

    public ProductCategory merge(EntityManager em) {
        return (ProductCategory)em.merge((Object)this);
    }

    public ProductCategory persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public ProductCategory remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public ProductCategory remove() {
        Context.remove(this);
        return this;
    }

    public ProductCategory delete() {
        return this.remove();
    }

    public ProductCategory refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public ProductCategory load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public ProductCategory load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<ProductCategory> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(ProductCategory.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            ProductCategory result = (ProductCategory)em.find(ProductCategory.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<ProductCategory> select(BooleanExpression<ProductCategory> where) {
        return new SelectBuilder(where).entityClass(ProductCategory.class).info(signaller.getInfo());
    }

    public static SelectBuilder<ProductCategory> select() {
        return ProductCategory.select(null);
    }

    public static class Attribute {
        public static final StringExpressionField<ProductCategory> categoryName = new StringExpressionField(new Field("categoryName"));
        public static final NumericExpressionField<ProductCategory> id = new NumericExpressionField(new Field("id.id"));
    }
}

