/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;

@Entity
@Table(schema="bookstore", name="product_selection")
public final class ProductSelection
implements xuml.tools.model.compiler.runtime.Entity<ProductSelection> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="product_selection_id", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="quantity", nullable=true)
    private volatile Integer quantity = new Integer("0");
    private static final BigDecimal QUANTITY_UPPER_LIMIT;
    private static final BigDecimal QUANTITY_LOWER_LIMIT;
    @Column(name="unit_price_of_selection", nullable=true, precision=2)
    private volatile Double unitPriceOfSelection = new Double("0");
    private static final BigDecimal UNITPRICEOFSELECTION_UPPER_LIMIT;
    private static final BigDecimal UNITPRICEOFSELECTION_LOWER_LIMIT;

    public ProductSelection() {
    }

    public ProductSelection(Integer id) {
        this.id = id;
    }

    public static ProductSelection create(Integer id) {
        return new ProductSelection(id);
    }

    public static ProductSelection create(CreationEvent<ProductSelection> creationEvent) {
        return Context.create(ProductSelection.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return ProductSelection.class.getName() + ":" + this.getId();
    }

    private void validateQuantity() {
        if (QUANTITY_UPPER_LIMIT.doubleValue() < (double)this.quantity.intValue()) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (QUANTITY_LOWER_LIMIT.doubleValue() > (double)this.quantity.intValue()) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    private void validateUnitPriceOfSelection() {
        if (UNITPRICEOFSELECTION_UPPER_LIMIT.doubleValue() < this.unitPriceOfSelection) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (UNITPRICEOFSELECTION_LOWER_LIMIT.doubleValue() > this.unitPriceOfSelection) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateQuantity();
        this.validateUnitPriceOfSelection();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateQuantity();
        this.validateUnitPriceOfSelection();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ProductSelection setQuantity_(Integer quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public Double getUnitPriceOfSelection() {
        return this.unitPriceOfSelection;
    }

    public void setUnitPriceOfSelection(Double unitPriceOfSelection) {
        this.unitPriceOfSelection = unitPriceOfSelection;
    }

    public ProductSelection setUnitPriceOfSelection_(Double unitPriceOfSelection) {
        this.setUnitPriceOfSelection(unitPriceOfSelection);
        return this;
    }

    public ProductSelection signal(Event<ProductSelection> event) {
        return this;
    }

    public ProductSelection signal(Event<ProductSelection> event, Duration delay) {
        return this;
    }

    public ProductSelection signal(Event<ProductSelection> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public ProductSelection cancelSignal(String eventSignatureKey) {
        return this;
    }

    public ProductSelection cancelSignal(Event<ProductSelection> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public ProductSelection event(Event<ProductSelection> event) {
        return this;
    }

    public ProductSelection merge(EntityManager em) {
        return (ProductSelection)em.merge((Object)this);
    }

    public ProductSelection persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public ProductSelection remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public ProductSelection remove() {
        Context.remove(this);
        return this;
    }

    public ProductSelection delete() {
        return this.remove();
    }

    public ProductSelection refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public ProductSelection load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public ProductSelection load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<ProductSelection> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(ProductSelection.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            ProductSelection result = (ProductSelection)em.find(ProductSelection.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<ProductSelection> select(BooleanExpression<ProductSelection> where) {
        return new SelectBuilder(where).entityClass(ProductSelection.class).info(signaller.getInfo());
    }

    public static SelectBuilder<ProductSelection> select() {
        return ProductSelection.select(null);
    }

    static {
        QUANTITY_UPPER_LIMIT = new BigDecimal("999999999999");
        QUANTITY_LOWER_LIMIT = new BigDecimal("0");
        UNITPRICEOFSELECTION_UPPER_LIMIT = new BigDecimal("999999999999");
        UNITPRICEOFSELECTION_LOWER_LIMIT = new BigDecimal("0");
    }

    public static class Attribute {
        public static final NumericExpressionField<ProductSelection> quantity = new NumericExpressionField(new Field("quantity"));
        public static final NumericExpressionField<ProductSelection> unitPriceOfSelection = new NumericExpressionField(new Field("unitPriceOfSelection"));
        public static final NumericExpressionField<ProductSelection> id = new NumericExpressionField(new Field("id.id"));
    }
}

