/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import bookstore.Product;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="publisher")
public final class Publisher
implements xuml.tools.model.compiler.runtime.Entity<Publisher> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @EmbeddedId
    private volatile PublisherId id;
    @Column(name="name", nullable=true, length=4096)
    private volatile String name = new String("");
    @Column(name="address", nullable=true, length=512)
    private volatile String address = new String("");
    @Column(name="website", nullable=true, length=2000)
    private volatile String website = new String("");
    @OneToMany(mappedBy="publisher_R1", cascade={CascadeType.MERGE, CascadeType.REFRESH, CascadeType.REMOVE}, fetch=FetchType.LAZY, targetEntity=Product.class)
    private Set<Product> product_R1 = Sets.newHashSet();

    public Publisher() {
    }

    public Publisher(PublisherId id) {
        this.id = id;
    }

    public static Publisher create(PublisherId id) {
        return new Publisher(id);
    }

    public static Publisher create(CreationEvent<Publisher> creationEvent) {
        return Context.create(Publisher.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return Publisher.class.getName() + ":" + this.getId();
    }

    private void validateName() {
        if (this.name == null || this.name.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.name == null || !this.name.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.name == null || !this.name.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.name == null || !Pattern.matches(".*", this.name)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateAddress() {
        if (this.address == null || this.address.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.address == null || !this.address.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.address == null || !this.address.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.address == null || !Pattern.matches(".*", this.address)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateWebsite() {
        if (this.website == null || this.website.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.website == null || !this.website.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.website == null || !this.website.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.website == null || !Pattern.matches(".*", this.website)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    public Set<Product> getProduct_R1() {
        return this.product_R1;
    }

    public void setProduct_R1(Set<Product> product_R1) {
        this.product_R1 = product_R1;
    }

    public Publisher relateAcrossR1(Product product_R1) {
        this.getProduct_R1().add(product_R1);
        product_R1.setPublisher_R1(this);
        return this;
    }

    public Publisher unrelateAcrossR1(Product product_R1) {
        this.getProduct_R1().remove(product_R1);
        product_R1.setPublisher_R1(null);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.id.validateGroupCode();
        this.id.validatePublisherCode();
        this.validateAddress();
        this.validateName();
        this.validateWebsite();
    }

    @PrePersist
    void validateBeforePersist() {
        this.id.validateGroupCode();
        this.id.validatePublisherCode();
        this.validateAddress();
        this.validateName();
        this.validateWebsite();
    }

    public PublisherId getId() {
        return this.id;
    }

    public void setId(PublisherId id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Publisher setName_(String name) {
        this.setName(name);
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Publisher setAddress_(String address) {
        this.setAddress(address);
        return this;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Publisher setWebsite_(String website) {
        this.setWebsite(website);
        return this;
    }

    public Publisher signal(Event<Publisher> event) {
        return this;
    }

    public Publisher signal(Event<Publisher> event, Duration delay) {
        return this;
    }

    public Publisher signal(Event<Publisher> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public Publisher cancelSignal(String eventSignatureKey) {
        return this;
    }

    public Publisher cancelSignal(Event<Publisher> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public Publisher event(Event<Publisher> event) {
        return this;
    }

    public Publisher merge(EntityManager em) {
        return (Publisher)em.merge((Object)this);
    }

    public Publisher persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public Publisher remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public Publisher remove() {
        Context.remove(this);
        return this;
    }

    public Publisher delete() {
        return this.remove();
    }

    public Publisher refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public Publisher load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public Publisher load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Publisher> find(PublisherId id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(Publisher.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            Publisher result = (Publisher)em.find(Publisher.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<Publisher> select(BooleanExpression<Publisher> where) {
        return new SelectBuilder(where).entityClass(Publisher.class).info(signaller.getInfo());
    }

    public static SelectBuilder<Publisher> select() {
        return Publisher.select(null);
    }

    public static class Attribute {
        public static final StringExpressionField<Publisher> name = new StringExpressionField(new Field("name"));
        public static final StringExpressionField<Publisher> address = new StringExpressionField(new Field("address"));
        public static final StringExpressionField<Publisher> website = new StringExpressionField(new Field("website"));
        public static final StringExpressionField<Publisher> publisherCode = new StringExpressionField(new Field("id.publisherCode"));
        public static final StringExpressionField<Publisher> groupCode = new StringExpressionField(new Field("id.groupCode"));
    }

    @Embeddable
    public static class PublisherId
    implements Serializable {
        @Column(name="publisher_code", nullable=false, length=2)
        private volatile String publisherCode = new String("");
        @Column(name="group_code", nullable=false, length=5)
        private volatile String groupCode = new String("");

        public PublisherId() {
        }

        public PublisherId(String publisherCode, String groupCode) {
            this.publisherCode = publisherCode;
            this.groupCode = groupCode;
        }

        private void validatePublisherCode() {
            if (this.publisherCode == null || this.publisherCode.length() < 2) {
                throw new ValidationException("min length constraint not met");
            }
            if (this.publisherCode == null || !this.publisherCode.startsWith("")) {
                throw new ValidationException("prefix constraint not met");
            }
            if (this.publisherCode == null || !this.publisherCode.endsWith("")) {
                throw new ValidationException("suffix constraint not met");
            }
            if (this.publisherCode == null || !Pattern.matches("[^\\s]{5}", this.publisherCode)) {
                throw new ValidationException("validation pattern constraint not met");
            }
        }

        private void validateGroupCode() {
            if (this.groupCode == null || this.groupCode.length() < 5) {
                throw new ValidationException("min length constraint not met");
            }
            if (this.groupCode == null || !this.groupCode.startsWith("")) {
                throw new ValidationException("prefix constraint not met");
            }
            if (this.groupCode == null || !this.groupCode.endsWith("")) {
                throw new ValidationException("suffix constraint not met");
            }
            if (this.groupCode == null || !Pattern.matches("\\d{5}", this.groupCode)) {
                throw new ValidationException("validation pattern constraint not met");
            }
        }

        public String getPublisherCode() {
            return this.publisherCode;
        }

        public void setPublisherCode(String publisherCode) {
            this.publisherCode = publisherCode;
        }

        public String getGroupCode() {
            return this.groupCode;
        }

        public void setGroupCode(String groupCode) {
            this.groupCode = groupCode;
        }

        public String toString() {
            StringBuffer _s = new StringBuffer();
            _s.append("PublisherId [");
            _s.append("publisherCode=");
            _s.append(this.publisherCode.toString());
            _s.append(",");
            _s.append("groupCode=");
            _s.append(this.groupCode.toString());
            _s.append("]");
            return _s.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PublisherId other = (PublisherId)obj;
            return Objects.equal((Object)this.publisherCode, (Object)other.publisherCode) && Objects.equal((Object)this.groupCode, (Object)other.groupCode);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.publisherCode, this.groupCode});
        }

        public static Builder builder() {
            return new Builder();
        }

        public PublisherId(Builder builder) {
            this.publisherCode = builder.publisherCode;
            this.groupCode = builder.groupCode;
        }

        public static class Builder {
            private String publisherCode;
            private String groupCode;

            public Builder publisherCode(String publisherCode) {
                this.publisherCode = publisherCode;
                return this;
            }

            public Builder groupCode(String groupCode) {
                this.groupCode = groupCode;
                return this;
            }

            public PublisherId build() {
                return new PublisherId(this);
            }
        }
    }
}

