/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import bookstore.Product;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="special_order_product")
public final class SpecialOrderProduct
implements xuml.tools.model.compiler.runtime.Entity<SpecialOrderProduct> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="special_order_product_id", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="special_order_instructions", nullable=true, length=4096)
    private volatile String specialOrderInstructions = new String("");
    @Column(name="days_to_deliver", nullable=true)
    private volatile Integer daysToDeliver = new Integer("0");
    private static final BigDecimal DAYSTODELIVER_UPPER_LIMIT;
    private static final BigDecimal DAYSTODELIVER_LOWER_LIMIT;
    @OneToOne(targetEntity=Product.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="product", referencedColumnName="product_id", nullable=false, insertable=true, updatable=true)})
    private Product product_R12;

    public SpecialOrderProduct() {
    }

    public SpecialOrderProduct(Integer id) {
        this.id = id;
    }

    public static SpecialOrderProduct create(Integer id) {
        return new SpecialOrderProduct(id);
    }

    public static SpecialOrderProduct create(CreationEvent<SpecialOrderProduct> creationEvent) {
        return Context.create(SpecialOrderProduct.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return SpecialOrderProduct.class.getName() + ":" + this.getId();
    }

    private void validateSpecialOrderInstructions() {
        if (this.specialOrderInstructions == null || this.specialOrderInstructions.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.specialOrderInstructions == null || !this.specialOrderInstructions.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.specialOrderInstructions == null || !this.specialOrderInstructions.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.specialOrderInstructions == null || !Pattern.matches(".*", this.specialOrderInstructions)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validateDaysToDeliver() {
        if (DAYSTODELIVER_UPPER_LIMIT.doubleValue() < (double)this.daysToDeliver.intValue()) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (DAYSTODELIVER_LOWER_LIMIT.doubleValue() > (double)this.daysToDeliver.intValue()) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    public Product getProduct_R12() {
        return this.product_R12;
    }

    public void setProduct_R12(Product product_R12) {
        this.product_R12 = product_R12;
    }

    public SpecialOrderProduct relateAcrossR12(Product product_R12) {
        this.setProduct_R12(product_R12);
        product_R12.setSpecialOrderProduct_R12(this);
        return this;
    }

    public SpecialOrderProduct unrelateAcrossR12(Product product_R12) {
        this.setProduct_R12(null);
        product_R12.setSpecialOrderProduct_R12(null);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateDaysToDeliver();
        this.validateSpecialOrderInstructions();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateDaysToDeliver();
        this.validateSpecialOrderInstructions();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getSpecialOrderInstructions() {
        return this.specialOrderInstructions;
    }

    public void setSpecialOrderInstructions(String specialOrderInstructions) {
        this.specialOrderInstructions = specialOrderInstructions;
    }

    public SpecialOrderProduct setSpecialOrderInstructions_(String specialOrderInstructions) {
        this.setSpecialOrderInstructions(specialOrderInstructions);
        return this;
    }

    public Integer getDaysToDeliver() {
        return this.daysToDeliver;
    }

    public void setDaysToDeliver(Integer daysToDeliver) {
        this.daysToDeliver = daysToDeliver;
    }

    public SpecialOrderProduct setDaysToDeliver_(Integer daysToDeliver) {
        this.setDaysToDeliver(daysToDeliver);
        return this;
    }

    public SpecialOrderProduct signal(Event<SpecialOrderProduct> event) {
        return this;
    }

    public SpecialOrderProduct signal(Event<SpecialOrderProduct> event, Duration delay) {
        return this;
    }

    public SpecialOrderProduct signal(Event<SpecialOrderProduct> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public SpecialOrderProduct cancelSignal(String eventSignatureKey) {
        return this;
    }

    public SpecialOrderProduct cancelSignal(Event<SpecialOrderProduct> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public SpecialOrderProduct event(Event<SpecialOrderProduct> event) {
        return this;
    }

    public SpecialOrderProduct merge(EntityManager em) {
        return (SpecialOrderProduct)em.merge((Object)this);
    }

    public SpecialOrderProduct persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public SpecialOrderProduct remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public SpecialOrderProduct remove() {
        Context.remove(this);
        return this;
    }

    public SpecialOrderProduct delete() {
        return this.remove();
    }

    public SpecialOrderProduct refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public SpecialOrderProduct load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public SpecialOrderProduct load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<SpecialOrderProduct> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(SpecialOrderProduct.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            SpecialOrderProduct result = (SpecialOrderProduct)em.find(SpecialOrderProduct.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<SpecialOrderProduct> select(BooleanExpression<SpecialOrderProduct> where) {
        return new SelectBuilder(where).entityClass(SpecialOrderProduct.class).info(signaller.getInfo());
    }

    public static SelectBuilder<SpecialOrderProduct> select() {
        return SpecialOrderProduct.select(null);
    }

    static {
        DAYSTODELIVER_UPPER_LIMIT = new BigDecimal("999999999999");
        DAYSTODELIVER_LOWER_LIMIT = new BigDecimal("0");
    }

    public static class Attribute {
        public static final StringExpressionField<SpecialOrderProduct> specialOrderInstructions = new StringExpressionField(new Field("specialOrderInstructions"));
        public static final NumericExpressionField<SpecialOrderProduct> daysToDeliver = new NumericExpressionField(new Field("daysToDeliver"));
        public static final NumericExpressionField<SpecialOrderProduct> id = new NumericExpressionField(new Field("id.id"));
    }
}

