/*
 * Decompiled with CFR 0.152.
 */
package bookstore;

import bookstore.Context;
import bookstore.Product;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="bookstore", name="stocked_product")
public final class StockedProduct
implements xuml.tools.model.compiler.runtime.Entity<StockedProduct> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="stocked_product_id", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="quantity_on_hand", nullable=true)
    private volatile Integer quantityOnHand = new Integer("0");
    private static final BigDecimal QUANTITYONHAND_UPPER_LIMIT;
    private static final BigDecimal QUANTITYONHAND_LOWER_LIMIT;
    @Column(name="reorder_threshold", nullable=true)
    private volatile Integer reorderThreshold = new Integer("0");
    private static final BigDecimal REORDERTHRESHOLD_UPPER_LIMIT;
    private static final BigDecimal REORDERTHRESHOLD_LOWER_LIMIT;
    @Column(name="reorder_increment", nullable=true)
    private volatile Integer reorderIncrement = new Integer("0");
    private static final BigDecimal REORDERINCREMENT_UPPER_LIMIT;
    private static final BigDecimal REORDERINCREMENT_LOWER_LIMIT;
    @Column(name="reorder_instructions", nullable=true, length=4096)
    private volatile String reorderInstructions = new String("");
    @OneToOne(targetEntity=Product.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="product", referencedColumnName="product_id", nullable=false, insertable=true, updatable=true)})
    private Product product_R12;

    public StockedProduct() {
    }

    public StockedProduct(Integer id) {
        this.id = id;
    }

    public static StockedProduct create(Integer id) {
        return new StockedProduct(id);
    }

    public static StockedProduct create(CreationEvent<StockedProduct> creationEvent) {
        return Context.create(StockedProduct.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return StockedProduct.class.getName() + ":" + this.getId();
    }

    private void validateQuantityOnHand() {
        if (QUANTITYONHAND_UPPER_LIMIT.doubleValue() < (double)this.quantityOnHand.intValue()) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (QUANTITYONHAND_LOWER_LIMIT.doubleValue() > (double)this.quantityOnHand.intValue()) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    private void validateReorderThreshold() {
        if (REORDERTHRESHOLD_UPPER_LIMIT.doubleValue() < (double)this.reorderThreshold.intValue()) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (REORDERTHRESHOLD_LOWER_LIMIT.doubleValue() > (double)this.reorderThreshold.intValue()) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    private void validateReorderIncrement() {
        if (REORDERINCREMENT_UPPER_LIMIT.doubleValue() < (double)this.reorderIncrement.intValue()) {
            throw new ValidationException("upper limit of 999999999999 failed");
        }
        if (REORDERINCREMENT_LOWER_LIMIT.doubleValue() > (double)this.reorderIncrement.intValue()) {
            throw new ValidationException("lower limit of 0 failed");
        }
    }

    private void validateReorderInstructions() {
        if (this.reorderInstructions == null || this.reorderInstructions.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.reorderInstructions == null || !this.reorderInstructions.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.reorderInstructions == null || !this.reorderInstructions.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.reorderInstructions == null || !Pattern.matches(".*", this.reorderInstructions)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    public Product getProduct_R12() {
        return this.product_R12;
    }

    public void setProduct_R12(Product product_R12) {
        this.product_R12 = product_R12;
    }

    public StockedProduct relateAcrossR12(Product product_R12) {
        this.setProduct_R12(product_R12);
        product_R12.setStockedProduct_R12(this);
        return this;
    }

    public StockedProduct unrelateAcrossR12(Product product_R12) {
        this.setProduct_R12(null);
        product_R12.setStockedProduct_R12(null);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateQuantityOnHand();
        this.validateReorderIncrement();
        this.validateReorderInstructions();
        this.validateReorderThreshold();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateQuantityOnHand();
        this.validateReorderIncrement();
        this.validateReorderInstructions();
        this.validateReorderThreshold();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getQuantityOnHand() {
        return this.quantityOnHand;
    }

    public void setQuantityOnHand(Integer quantityOnHand) {
        this.quantityOnHand = quantityOnHand;
    }

    public StockedProduct setQuantityOnHand_(Integer quantityOnHand) {
        this.setQuantityOnHand(quantityOnHand);
        return this;
    }

    public Integer getReorderThreshold() {
        return this.reorderThreshold;
    }

    public void setReorderThreshold(Integer reorderThreshold) {
        this.reorderThreshold = reorderThreshold;
    }

    public StockedProduct setReorderThreshold_(Integer reorderThreshold) {
        this.setReorderThreshold(reorderThreshold);
        return this;
    }

    public Integer getReorderIncrement() {
        return this.reorderIncrement;
    }

    public void setReorderIncrement(Integer reorderIncrement) {
        this.reorderIncrement = reorderIncrement;
    }

    public StockedProduct setReorderIncrement_(Integer reorderIncrement) {
        this.setReorderIncrement(reorderIncrement);
        return this;
    }

    public String getReorderInstructions() {
        return this.reorderInstructions;
    }

    public void setReorderInstructions(String reorderInstructions) {
        this.reorderInstructions = reorderInstructions;
    }

    public StockedProduct setReorderInstructions_(String reorderInstructions) {
        this.setReorderInstructions(reorderInstructions);
        return this;
    }

    public StockedProduct signal(Event<StockedProduct> event) {
        return this;
    }

    public StockedProduct signal(Event<StockedProduct> event, Duration delay) {
        return this;
    }

    public StockedProduct signal(Event<StockedProduct> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public StockedProduct cancelSignal(String eventSignatureKey) {
        return this;
    }

    public StockedProduct cancelSignal(Event<StockedProduct> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public StockedProduct event(Event<StockedProduct> event) {
        return this;
    }

    public StockedProduct merge(EntityManager em) {
        return (StockedProduct)em.merge((Object)this);
    }

    public StockedProduct persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public StockedProduct remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public StockedProduct remove() {
        Context.remove(this);
        return this;
    }

    public StockedProduct delete() {
        return this.remove();
    }

    public StockedProduct refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public StockedProduct load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public StockedProduct load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<StockedProduct> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(StockedProduct.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            StockedProduct result = (StockedProduct)em.find(StockedProduct.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<StockedProduct> select(BooleanExpression<StockedProduct> where) {
        return new SelectBuilder(where).entityClass(StockedProduct.class).info(signaller.getInfo());
    }

    public static SelectBuilder<StockedProduct> select() {
        return StockedProduct.select(null);
    }

    static {
        QUANTITYONHAND_UPPER_LIMIT = new BigDecimal("999999999999");
        QUANTITYONHAND_LOWER_LIMIT = new BigDecimal("0");
        REORDERTHRESHOLD_UPPER_LIMIT = new BigDecimal("999999999999");
        REORDERTHRESHOLD_LOWER_LIMIT = new BigDecimal("0");
        REORDERINCREMENT_UPPER_LIMIT = new BigDecimal("999999999999");
        REORDERINCREMENT_LOWER_LIMIT = new BigDecimal("0");
    }

    public static class Attribute {
        public static final NumericExpressionField<StockedProduct> quantityOnHand = new NumericExpressionField(new Field("quantityOnHand"));
        public static final NumericExpressionField<StockedProduct> reorderThreshold = new NumericExpressionField(new Field("reorderThreshold"));
        public static final NumericExpressionField<StockedProduct> reorderIncrement = new NumericExpressionField(new Field("reorderIncrement"));
        public static final StringExpressionField<StockedProduct> reorderInstructions = new StringExpressionField(new Field("reorderInstructions"));
        public static final NumericExpressionField<StockedProduct> id = new NumericExpressionField(new Field("id.id"));
    }
}

