/*
 * Decompiled with CFR 0.152.
 */
package extensions;

import com.google.common.base.Optional;
import extensions.Context;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="extensions", name="a_1")
public final class A
implements xuml.tools.model.compiler.runtime.Entity<A> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="one", nullable=false)
    private volatile Integer id = new Integer("1");
    @Column(name="email", nullable=true, length=4096)
    private volatile String email = new String("");
    @Column(name="postcode", nullable=true)
    private volatile Integer postcode = new Integer("0");
    private static final BigDecimal POSTCODE_UPPER_LIMIT;
    private static final BigDecimal POSTCODE_LOWER_LIMIT;

    public A() {
    }

    public A(Integer id) {
        this.id = id;
    }

    public static A create(Integer id) {
        return new A(id);
    }

    public static A create(CreationEvent<A> creationEvent) {
        return Context.create(A.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return A.class.getName() + ":" + this.getId();
    }

    private void validateEmail() {
        if (this.email == null || this.email.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.email == null || !this.email.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.email == null || !this.email.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.email == null || !Pattern.matches(".*", this.email)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void validatePostcode() {
        if (POSTCODE_UPPER_LIMIT.doubleValue() < (double)this.postcode.intValue()) {
            throw new ValidationException("upper limit of 99999999999 failed");
        }
        if (POSTCODE_LOWER_LIMIT.doubleValue() > (double)this.postcode.intValue()) {
            throw new ValidationException("lower limit of -9999999999999 failed");
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateEmail();
        this.validatePostcode();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateEmail();
        this.validatePostcode();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public A setEmail_(String email) {
        this.setEmail(email);
        return this;
    }

    public Integer getPostcode() {
        return this.postcode;
    }

    public void setPostcode(Integer postcode) {
        this.postcode = postcode;
    }

    public A setPostcode_(Integer postcode) {
        this.setPostcode(postcode);
        return this;
    }

    public A signal(Event<A> event) {
        return this;
    }

    public A signal(Event<A> event, Duration delay) {
        return this;
    }

    public A signal(Event<A> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public A cancelSignal(String eventSignatureKey) {
        return this;
    }

    public A cancelSignal(Event<A> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public A event(Event<A> event) {
        return this;
    }

    public A merge(EntityManager em) {
        return (A)em.merge((Object)this);
    }

    public A persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public A remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public A remove() {
        Context.remove(this);
        return this;
    }

    public A delete() {
        return this.remove();
    }

    public A refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public A load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public A load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<A> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(A.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            A result = (A)em.find(A.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static List<A> findById(Integer id) {
        EntityManager em = Context.createEntityManager();
        List list = em.createQuery("select e from A e where e.id=:id").setParameter("id", (Object)id).getResultList();
        em.close();
        return list;
    }

    public static List<A> findById(EntityManager em, Integer id) {
        List list = em.createQuery("select e from A e where e.id=:id").setParameter("id", (Object)id).getResultList();
        return list;
    }

    public static List<A> findByEmailPostcode(String email, Integer postcode) {
        EntityManager em = Context.createEntityManager();
        List list = em.createQuery("select e from A e where e.email=:email and e.postcode=:postcode").setParameter("email", (Object)email).setParameter("postcode", (Object)postcode).getResultList();
        em.close();
        return list;
    }

    public static List<A> findByEmailPostcode(EntityManager em, String email, Integer postcode) {
        List list = em.createQuery("select e from A e where e.email=:email and e.postcode=:postcode").setParameter("email", (Object)email).setParameter("postcode", (Object)postcode).getResultList();
        return list;
    }

    public static SelectBuilder<A> select(BooleanExpression<A> where) {
        return new SelectBuilder(where).entityClass(A.class).info(signaller.getInfo());
    }

    public static SelectBuilder<A> select() {
        return A.select(null);
    }

    static {
        POSTCODE_UPPER_LIMIT = new BigDecimal("99999999999");
        POSTCODE_LOWER_LIMIT = new BigDecimal("-9999999999999");
    }

    public static class Attribute {
        public static final StringExpressionField<A> email = new StringExpressionField(new Field("email"));
        public static final NumericExpressionField<A> postcode = new NumericExpressionField(new Field("postcode"));
        public static final NumericExpressionField<A> id = new NumericExpressionField(new Field("id.id"));
    }
}

