/*
 * Decompiled with CFR 0.152.
 */
package one_many_to_one_many_association;

import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import one_many_to_one_many_association.A;
import one_many_to_one_many_association.B;
import one_many_to_one_many_association.Context;
import scala.concurrent.duration.Duration;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.RelationshipNotEstablishedException;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="one_many_to_one_many_association", name="c_1")
public final class C
implements xuml.tools.model.compiler.runtime.Entity<C> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="c_one", nullable=false, length=4096)
    private volatile String id = new String("");
    @Column(name="description", nullable=true, length=4096)
    private volatile String description = new String("");
    @ManyToOne(targetEntity=B.class)
    @JoinColumns(value={@JoinColumn(name="c_b_one", referencedColumnName="b_one", nullable=false, insertable=true, updatable=true)})
    private B b_R1;
    @ManyToOne(targetEntity=A.class)
    @JoinColumns(value={@JoinColumn(name="c_a_one", referencedColumnName="a_one", nullable=false, insertable=true, updatable=true)})
    private A a_R1;

    public C() {
    }

    public C(String id) {
        this.id = id;
    }

    public static C create(String id) {
        return new C(id);
    }

    public static C create(CreationEvent<C> creationEvent) {
        return Context.create(C.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return C.class.getName() + ":" + this.getId();
    }

    private void validateDescription() {
        if (this.description == null || this.description.length() < 1) {
            throw new ValidationException("min length constraint not met");
        }
        if (this.description == null || !this.description.startsWith("")) {
            throw new ValidationException("prefix constraint not met");
        }
        if (this.description == null || !this.description.endsWith("")) {
            throw new ValidationException("suffix constraint not met");
        }
        if (this.description == null || !Pattern.matches(".*", this.description)) {
            throw new ValidationException("validation pattern constraint not met");
        }
    }

    private void _validateB_R1() {
        if (this.b_R1 == null) {
            throw new RelationshipNotEstablishedException("? not established and is mandatory");
        }
    }

    public B getB_R1() {
        return this.b_R1;
    }

    public void setB_R1(B b_R1) {
        this.b_R1 = b_R1;
    }

    public C relateAcrossR1(B b_R1) {
        this.setB_R1(b_R1);
        b_R1.getC_R1().add(this);
        return this;
    }

    public C unrelateAcrossR1(B b_R1) {
        this.setB_R1(null);
        b_R1.getC_R1().remove(this);
        return this;
    }

    private void _validateA_R1() {
        if (this.a_R1 == null) {
            throw new RelationshipNotEstablishedException("? not established and is mandatory");
        }
    }

    public A getA_R1() {
        return this.a_R1;
    }

    public void setA_R1(A a_R1) {
        this.a_R1 = a_R1;
    }

    public C relateAcrossR1(A a_R1) {
        this.setA_R1(a_R1);
        a_R1.getC_R1().add(this);
        return this;
    }

    public C unrelateAcrossR1(A a_R1) {
        this.setA_R1(null);
        a_R1.getC_R1().remove(this);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this._validateA_R1();
        this._validateB_R1();
        this.validateDescription();
    }

    @PrePersist
    void validateBeforePersist() {
        this._validateA_R1();
        this._validateB_R1();
        this.validateDescription();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public C setDescription_(String description) {
        this.setDescription(description);
        return this;
    }

    public C signal(Event<C> event) {
        return this;
    }

    public C signal(Event<C> event, Duration delay) {
        return this;
    }

    public C signal(Event<C> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public C cancelSignal(String eventSignatureKey) {
        return this;
    }

    public C cancelSignal(Event<C> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public C event(Event<C> event) {
        return this;
    }

    public C merge(EntityManager em) {
        return (C)em.merge((Object)this);
    }

    public C persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public C remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public C remove() {
        Context.remove(this);
        return this;
    }

    public C delete() {
        return this.remove();
    }

    public C refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public C load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public C load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<C> find(String id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(C.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            C result = (C)em.find(C.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<C> select(BooleanExpression<C> where) {
        return new SelectBuilder(where).entityClass(C.class).info(signaller.getInfo());
    }

    public static SelectBuilder<C> select() {
        return C.select(null);
    }

    public static class Attribute {
        public static final StringExpressionField<C> description = new StringExpressionField(new Field("description"));
        public static final StringExpressionField<C> id = new StringExpressionField(new Field("id.id"));
    }
}

