/*
 * Decompiled with CFR 0.152.
 */
package specialization;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import specialization.B;
import specialization.C;
import specialization.Context;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.RelationshipNotEstablishedException;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.TooManySpecializationsException;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="specialization", name="a_1")
public final class A
implements xuml.tools.model.compiler.runtime.Entity<A> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="one", nullable=false, length=4096)
    private volatile String id = new String("");
    @Column(name="two", nullable=true)
    private volatile Integer two = new Integer("0");
    private static final BigDecimal TWO_UPPER_LIMIT;
    private static final BigDecimal TWO_LOWER_LIMIT;
    @OneToOne(mappedBy="a_R1", fetch=FetchType.LAZY, targetEntity=B.class)
    private B b_R1;
    @OneToOne(mappedBy="a_R1", fetch=FetchType.LAZY, targetEntity=C.class)
    private C c_R1;

    public A() {
    }

    public A(String id) {
        this.id = id;
    }

    public static A create(String id) {
        return new A(id);
    }

    public static A create(CreationEvent<A> creationEvent) {
        return Context.create(A.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return A.class.getName() + ":" + this.getId();
    }

    private void validateTwo() {
        if (TWO_UPPER_LIMIT.doubleValue() < (double)this.two.intValue()) {
            throw new ValidationException("upper limit of 99999999999 failed");
        }
        if (TWO_LOWER_LIMIT.doubleValue() > (double)this.two.intValue()) {
            throw new ValidationException("lower limit of -9999999999999 failed");
        }
    }

    public B getB_R1() {
        return this.b_R1;
    }

    public void setB_R1(B b_R1) {
        this.b_R1 = b_R1;
    }

    public A relateAcrossR1(B b_R1) {
        this.setB_R1(b_R1);
        b_R1.setA_R1(this);
        return this;
    }

    public A unrelateAcrossR1(B b_R1) {
        this.setB_R1(null);
        b_R1.setA_R1(null);
        return this;
    }

    public C getC_R1() {
        return this.c_R1;
    }

    public void setC_R1(C c_R1) {
        this.c_R1 = c_R1;
    }

    public A relateAcrossR1(C c_R1) {
        this.setC_R1(c_R1);
        c_R1.setA_R1(this);
        return this;
    }

    public A unrelateAcrossR1(C c_R1) {
        this.setC_R1(null);
        c_R1.setA_R1(null);
        return this;
    }

    private void validateSpecializationR1() {
        int count = 0;
        if (this.c_R1 != null) {
            ++count;
        }
        if (this.b_R1 != null) {
            ++count;
        }
        if (count == 0) {
            throw new RelationshipNotEstablishedException("wrong number of specializations = " + count);
        }
        if (count != 1) {
            throw new TooManySpecializationsException("wrong number of specializations = " + count);
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateSpecializationR1();
        this.validateTwo();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateSpecializationR1();
        this.validateTwo();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getTwo() {
        return this.two;
    }

    public void setTwo(Integer two) {
        this.two = two;
    }

    public A setTwo_(Integer two) {
        this.setTwo(two);
        return this;
    }

    public A signal(Event<A> event) {
        return this;
    }

    public A signal(Event<A> event, Duration delay) {
        return this;
    }

    public A signal(Event<A> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public A cancelSignal(String eventSignatureKey) {
        return this;
    }

    public A cancelSignal(Event<A> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public A event(Event<A> event) {
        return this;
    }

    public A merge(EntityManager em) {
        return (A)em.merge((Object)this);
    }

    public A persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public A remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public A remove() {
        Context.remove(this);
        return this;
    }

    public A delete() {
        return this.remove();
    }

    public A refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public A load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public A load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<A> find(String id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(A.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            A result = (A)em.find(A.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<A> select(BooleanExpression<A> where) {
        return new SelectBuilder(where).entityClass(A.class).info(signaller.getInfo());
    }

    public static SelectBuilder<A> select() {
        return A.select(null);
    }

    static {
        TWO_UPPER_LIMIT = new BigDecimal("99999999999");
        TWO_LOWER_LIMIT = new BigDecimal("-9999999999999");
    }

    public static class Attribute {
        public static final NumericExpressionField<A> two = new NumericExpressionField(new Field("two"));
        public static final StringExpressionField<A> id = new StringExpressionField(new Field("id.id"));
    }
}

