/*
 * Decompiled with CFR 0.152.
 */
package specialization;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import specialization.A;
import specialization.Context;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="specialization", name="b")
public final class B
implements xuml.tools.model.compiler.runtime.Entity<B> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="name", nullable=false, length=4096)
    private volatile String id = new String("");
    @Column(name="number", nullable=true)
    private volatile Integer number = new Integer("0");
    private static final BigDecimal NUMBER_UPPER_LIMIT;
    private static final BigDecimal NUMBER_LOWER_LIMIT;
    @OneToOne(targetEntity=A.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="a_one", referencedColumnName="one", nullable=false, insertable=true, updatable=true)})
    private A a_R1;

    public B() {
    }

    public B(String id) {
        this.id = id;
    }

    public static B create(String id) {
        return new B(id);
    }

    public static B create(CreationEvent<B> creationEvent) {
        return Context.create(B.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return B.class.getName() + ":" + this.getId();
    }

    private void validateNumber() {
        if (NUMBER_UPPER_LIMIT.doubleValue() < (double)this.number.intValue()) {
            throw new ValidationException("upper limit of 99999999999 failed");
        }
        if (NUMBER_LOWER_LIMIT.doubleValue() > (double)this.number.intValue()) {
            throw new ValidationException("lower limit of -9999999999999 failed");
        }
    }

    public A getA_R1() {
        return this.a_R1;
    }

    public void setA_R1(A a_R1) {
        this.a_R1 = a_R1;
    }

    public B relateAcrossR1(A a_R1) {
        this.setA_R1(a_R1);
        a_R1.setB_R1(this);
        return this;
    }

    public B unrelateAcrossR1(A a_R1) {
        this.setA_R1(null);
        a_R1.setB_R1(null);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateNumber();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateNumber();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public B setNumber_(Integer number) {
        this.setNumber(number);
        return this;
    }

    public B signal(Event<B> event) {
        return this;
    }

    public B signal(Event<B> event, Duration delay) {
        return this;
    }

    public B signal(Event<B> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public B cancelSignal(String eventSignatureKey) {
        return this;
    }

    public B cancelSignal(Event<B> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public B event(Event<B> event) {
        return this;
    }

    public B merge(EntityManager em) {
        return (B)em.merge((Object)this);
    }

    public B persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public B remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public B remove() {
        Context.remove(this);
        return this;
    }

    public B delete() {
        return this.remove();
    }

    public B refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public B load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public B load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<B> find(String id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(B.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            B result = (B)em.find(B.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<B> select(BooleanExpression<B> where) {
        return new SelectBuilder(where).entityClass(B.class).info(signaller.getInfo());
    }

    public static SelectBuilder<B> select() {
        return B.select(null);
    }

    static {
        NUMBER_UPPER_LIMIT = new BigDecimal("99999999999");
        NUMBER_LOWER_LIMIT = new BigDecimal("-9999999999999");
    }

    public static class Attribute {
        public static final NumericExpressionField<B> number = new NumericExpressionField(new Field("number"));
        public static final StringExpressionField<B> id = new StringExpressionField(new Field("id.id"));
    }
}

