/*
 * Decompiled with CFR 0.152.
 */
package specialization;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import specialization.A;
import specialization.Context;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;
import xuml.tools.model.compiler.runtime.query.StringExpressionField;

@Entity
@Table(schema="specialization", name="c_1")
public final class C
implements xuml.tools.model.compiler.runtime.Entity<C> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="category", nullable=false, length=4096)
    private volatile String id = new String("");
    @Column(name="count", nullable=true)
    private volatile Integer count = new Integer("0");
    private static final BigDecimal COUNT_UPPER_LIMIT;
    private static final BigDecimal COUNT_LOWER_LIMIT;
    @OneToOne(targetEntity=A.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="a_one", referencedColumnName="one", nullable=false, insertable=true, updatable=true)})
    private A a_R1;

    public C() {
    }

    public C(String id) {
        this.id = id;
    }

    public static C create(String id) {
        return new C(id);
    }

    public static C create(CreationEvent<C> creationEvent) {
        return Context.create(C.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return C.class.getName() + ":" + this.getId();
    }

    private void validateCount() {
        if (COUNT_UPPER_LIMIT.doubleValue() < (double)this.count.intValue()) {
            throw new ValidationException("upper limit of 99999999999 failed");
        }
        if (COUNT_LOWER_LIMIT.doubleValue() > (double)this.count.intValue()) {
            throw new ValidationException("lower limit of -9999999999999 failed");
        }
    }

    public A getA_R1() {
        return this.a_R1;
    }

    public void setA_R1(A a_R1) {
        this.a_R1 = a_R1;
    }

    public C relateAcrossR1(A a_R1) {
        this.setA_R1(a_R1);
        a_R1.setC_R1(this);
        return this;
    }

    public C unrelateAcrossR1(A a_R1) {
        this.setA_R1(null);
        a_R1.setC_R1(null);
        return this;
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateCount();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateCount();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public C setCount_(Integer count) {
        this.setCount(count);
        return this;
    }

    public C signal(Event<C> event) {
        return this;
    }

    public C signal(Event<C> event, Duration delay) {
        return this;
    }

    public C signal(Event<C> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public C cancelSignal(String eventSignatureKey) {
        return this;
    }

    public C cancelSignal(Event<C> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public C event(Event<C> event) {
        return this;
    }

    public C merge(EntityManager em) {
        return (C)em.merge((Object)this);
    }

    public C persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public C remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public C remove() {
        Context.remove(this);
        return this;
    }

    public C delete() {
        return this.remove();
    }

    public C refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public C load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public C load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<C> find(String id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(C.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            C result = (C)em.find(C.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<C> select(BooleanExpression<C> where) {
        return new SelectBuilder(where).entityClass(C.class).info(signaller.getInfo());
    }

    public static SelectBuilder<C> select() {
        return C.select(null);
    }

    static {
        COUNT_UPPER_LIMIT = new BigDecimal("99999999999");
        COUNT_LOWER_LIMIT = new BigDecimal("-9999999999999");
    }

    public static class Attribute {
        public static final NumericExpressionField<C> count = new NumericExpressionField(new Field("count"));
        public static final StringExpressionField<C> id = new StringExpressionField(new Field("id.id"));
    }
}

