/*
 * Decompiled with CFR 0.152.
 */
package unary_many_association;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import scala.concurrent.duration.Duration;
import unary_many_association.Context;
import xuml.tools.model.compiler.runtime.CreationEvent;
import xuml.tools.model.compiler.runtime.EntityHelper;
import xuml.tools.model.compiler.runtime.Event;
import xuml.tools.model.compiler.runtime.Signaller;
import xuml.tools.model.compiler.runtime.ValidationException;
import xuml.tools.model.compiler.runtime.query.BooleanExpression;
import xuml.tools.model.compiler.runtime.query.Field;
import xuml.tools.model.compiler.runtime.query.NumericExpressionField;
import xuml.tools.model.compiler.runtime.query.SelectBuilder;

@Entity
@Table(schema="unary_many_assocation", name="b")
public final class B
implements xuml.tools.model.compiler.runtime.Entity<B> {
    private static Signaller signaller;
    @Transient
    private EntityHelper _helper;
    @Id
    @Column(name="id", nullable=false)
    private volatile Integer id = new Integer("0");
    @Column(name="contact_frequency_per_year", nullable=true, precision=20)
    private volatile Double contactFrequencyPerYear = new Double("0");
    private static final BigDecimal CONTACTFREQUENCYPERYEAR_UPPER_LIMIT;
    private static final BigDecimal CONTACTFREQUENCYPERYEAR_LOWER_LIMIT;

    public B() {
    }

    public B(Integer id) {
        this.id = id;
    }

    public static B create(Integer id) {
        return new B(id);
    }

    public static B create(CreationEvent<B> creationEvent) {
        return Context.create(B.class, creationEvent);
    }

    static void setSignaller_(Signaller sig) {
        signaller = sig;
    }

    public synchronized EntityHelper helper() {
        if (this._helper == null) {
            this._helper = new EntityHelper(signaller, (xuml.tools.model.compiler.runtime.Entity)this);
        }
        return this._helper;
    }

    public String uniqueId() {
        return B.class.getName() + ":" + this.getId();
    }

    private void validateContactFrequencyPerYear() {
        if (CONTACTFREQUENCYPERYEAR_UPPER_LIMIT.doubleValue() < this.contactFrequencyPerYear) {
            throw new ValidationException("upper limit of 99999999999 failed");
        }
        if (CONTACTFREQUENCYPERYEAR_LOWER_LIMIT.doubleValue() > this.contactFrequencyPerYear) {
            throw new ValidationException("lower limit of -9999999999999 failed");
        }
    }

    @PreUpdate
    void validateBeforeUpdate() {
        this.validateContactFrequencyPerYear();
    }

    @PrePersist
    void validateBeforePersist() {
        this.validateContactFrequencyPerYear();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Double getContactFrequencyPerYear() {
        return this.contactFrequencyPerYear;
    }

    public void setContactFrequencyPerYear(Double contactFrequencyPerYear) {
        this.contactFrequencyPerYear = contactFrequencyPerYear;
    }

    public B setContactFrequencyPerYear_(Double contactFrequencyPerYear) {
        this.setContactFrequencyPerYear(contactFrequencyPerYear);
        return this;
    }

    public B signal(Event<B> event) {
        return this;
    }

    public B signal(Event<B> event, Duration delay) {
        return this;
    }

    public B signal(Event<B> event, long time) {
        return this.signal((Event)event, (Duration)Duration.create((long)(time - System.currentTimeMillis()), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public B cancelSignal(String eventSignatureKey) {
        return this;
    }

    public B cancelSignal(Event<B> event) {
        return this.cancelSignal(event.signatureKey());
    }

    public B event(Event<B> event) {
        return this;
    }

    public B merge(EntityManager em) {
        return (B)em.merge((Object)this);
    }

    public B persist(EntityManager em) {
        em.persist((Object)this);
        return this;
    }

    public B remove(EntityManager em) {
        em.remove((Object)this);
        return this;
    }

    public B remove() {
        Context.remove(this);
        return this;
    }

    public B delete() {
        return this.remove();
    }

    public B refresh(EntityManager em) {
        em.refresh((Object)this);
        return this;
    }

    public B load(EntityManager em) {
        return this.merge(em).refresh(em);
    }

    public B load() {
        return Context.load(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<B> find(Integer id) {
        if (Context.em() != null) {
            return Optional.fromNullable((Object)Context.em().find(B.class, (Object)id));
        }
        try (EntityManager em = Context.createEntityManager();){
            B result = (B)em.find(B.class, (Object)id);
            Optional optional = Optional.fromNullable((Object)result);
            return optional;
        }
    }

    public static SelectBuilder<B> select(BooleanExpression<B> where) {
        return new SelectBuilder(where).entityClass(B.class).info(signaller.getInfo());
    }

    public static SelectBuilder<B> select() {
        return B.select(null);
    }

    static {
        CONTACTFREQUENCYPERYEAR_UPPER_LIMIT = new BigDecimal("99999999999");
        CONTACTFREQUENCYPERYEAR_LOWER_LIMIT = new BigDecimal("-9999999999999");
    }

    public static class Attribute {
        public static final NumericExpressionField<B> contactFrequencyPerYear = new NumericExpressionField(new Field("contactFrequencyPerYear"));
        public static final NumericExpressionField<B> id = new NumericExpressionField(new Field("id.id"));
    }
}

