/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.DefaultRepositoryHandler;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.MavenPluginConvention;
import org.gradle.api.plugins.MavenRepositoryHandlerConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.publication.maven.internal.DefaultDeployerFactory;
import org.gradle.api.publication.maven.internal.DefaultMavenRepositoryHandlerConvention;
import org.gradle.api.publication.maven.internal.DeployerFactory;
import org.gradle.api.publication.maven.internal.MavenFactory;
import org.gradle.api.publication.maven.internal.MavenPomMetaInfoProvider;
import org.gradle.api.tasks.Upload;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.internal.Factory;
import org.gradle.internal.logging.LoggingManagerInternal;

public class AndroidMavenPlugin
implements Plugin<ProjectInternal> {
    public static final int COMPILE_PRIORITY = 300;
    public static final int RUNTIME_PRIORITY = 200;
    public static final int TEST_COMPILE_PRIORITY = 150;
    public static final int TEST_RUNTIME_PRIORITY = 100;
    public static final int PROVIDED_COMPILE_PRIORITY = 400;
    public static final int PROVIDED_RUNTIME_PRIORITY = 450;
    public static final String INSTALL_TASK_NAME = "install";
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final FileResolver fileResolver;
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurationActionContainer configurationActionContainer;
    private final MavenSettingsProvider mavenSettingsProvider;
    private final LocalMavenRepositoryLocator mavenRepositoryLocator;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private Project project;

    @Inject
    public AndroidMavenPlugin(Factory<LoggingManagerInternal> loggingManagerFactory, FileResolver fileResolver, ProjectPublicationRegistry publicationRegistry, ProjectConfigurationActionContainer configurationActionContainer, MavenSettingsProvider mavenSettingsProvider, LocalMavenRepositoryLocator mavenRepositoryLocator, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.loggingManagerFactory = loggingManagerFactory;
        this.fileResolver = fileResolver;
        this.publicationRegistry = publicationRegistry;
        this.configurationActionContainer = configurationActionContainer;
        this.mavenSettingsProvider = mavenSettingsProvider;
        this.mavenRepositoryLocator = mavenRepositoryLocator;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void apply(final ProjectInternal project) {
        this.project = project;
        project.getPluginManager().apply(BasePlugin.class);
        MavenFactory mavenFactory = (MavenFactory)project.getServices().get(MavenFactory.class);
        final MavenPluginConvention pluginConvention = this.addConventionObject(project, mavenFactory);
        DefaultDeployerFactory deployerFactory = new DefaultDeployerFactory(mavenFactory, this.loggingManagerFactory, this.fileResolver, (MavenPomMetaInfoProvider)pluginConvention, project.getConfigurations(), pluginConvention.getConf2ScopeMappings(), this.mavenSettingsProvider, this.mavenRepositoryLocator);
        this.configureUploadTasks(deployerFactory);
        this.configureUploadArchivesTask();
        PluginContainer plugins = project.getPlugins();
        try {
            Class<?> appPluginClass = Class.forName("com.android.build.gradle.AppPlugin");
            Class<?> libraryPluginClass = Class.forName("com.android.build.gradle.LibraryPlugin");
            Class<?> testPluginClass = Class.forName("com.android.build.gradle.TestPlugin");
            plugins.withType(appPluginClass, (Action)new Action<Plugin>(){

                public void execute(Plugin appPlugin) {
                    AndroidMavenPlugin.this.configureAndroidScopeMappings(project.getConfigurations(), pluginConvention.getConf2ScopeMappings());
                }
            });
            plugins.withType(libraryPluginClass, (Action)new Action<Plugin>(){

                public void execute(Plugin libraryPlugin) {
                    AndroidMavenPlugin.this.configureAndroidScopeMappings(project.getConfigurations(), pluginConvention.getConf2ScopeMappings());
                }
            });
            plugins.withType(testPluginClass, (Action)new Action<Plugin>(){

                public void execute(Plugin testPlugin) {
                    AndroidMavenPlugin.this.configureAndroidScopeMappings(project.getConfigurations(), pluginConvention.getConf2ScopeMappings());
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        plugins.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                AndroidMavenPlugin.this.configureJavaScopeMappings(project.getConfigurations(), pluginConvention.getConf2ScopeMappings());
            }
        });
        plugins.withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaPlugin) {
                AndroidMavenPlugin.this.configureInstall((Project)project);
            }
        });
        plugins.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                AndroidMavenPlugin.this.configureWarScopeMappings(project.getConfigurations(), pluginConvention.getConf2ScopeMappings());
            }
        });
        plugins.withType(JavaLibraryPlugin.class, (Action)new Action<JavaLibraryPlugin>(){

            public void execute(JavaLibraryPlugin javaLibraryPlugin) {
                AndroidMavenPlugin.this.configureJavaLibraryScopeMappings(project.getConfigurations(), pluginConvention.getConf2ScopeMappings());
            }
        });
    }

    private void configureUploadTasks(final DefaultDeployerFactory deployerFactory) {
        this.project.getTasks().withType(Upload.class, (Action)new Action<Upload>(){

            public void execute(Upload upload) {
                RepositoryHandler repositories = upload.getRepositories();
                DefaultRepositoryHandler handler = (DefaultRepositoryHandler)repositories;
                DefaultMavenRepositoryHandlerConvention repositoryConvention = new DefaultMavenRepositoryHandlerConvention(handler, (DeployerFactory)deployerFactory);
                new DslObject((Object)repositories).getConvention().getPlugins().put("maven", repositoryConvention);
            }
        });
    }

    private void configureUploadArchivesTask() {
        this.configurationActionContainer.add((Action)new Action<Project>(){

            public void execute(Project project) {
                Upload uploadArchives = (Upload)project.getTasks().withType(Upload.class).findByName("uploadArchives");
                if (uploadArchives == null) {
                    return;
                }
                ConfigurationInternal configuration = (ConfigurationInternal)uploadArchives.getConfiguration();
                Module module = configuration.getModule();
                for (MavenResolver resolver : uploadArchives.getRepositories().withType(MavenResolver.class)) {
                    MavenPom pom = resolver.getPom();
                    ModuleVersionIdentifier publicationId = AndroidMavenPlugin.this.moduleIdentifierFactory.moduleWithVersion(pom.getGroupId().equals("unknown") ? module.getGroup() : pom.getGroupId(), pom.getArtifactId().equals("empty-project") ? module.getName() : pom.getArtifactId(), pom.getVersion().equals("0") ? module.getVersion() : pom.getVersion());
                    AndroidMavenPlugin.this.publicationRegistry.registerPublication(project.getPath(), (ProjectPublication)new DefaultProjectPublication(publicationId));
                }
            }
        });
    }

    private MavenPluginConvention addConventionObject(ProjectInternal project, MavenFactory mavenFactory) {
        MavenPluginConvention mavenConvention = new MavenPluginConvention(project, mavenFactory);
        Convention convention = project.getConvention();
        convention.getPlugins().put("maven", mavenConvention);
        return mavenConvention;
    }

    private void configureAndroidScopeMappings(ConfigurationContainer configurations, Conf2ScopeMappingContainer mavenScopeMappings) {
        mavenScopeMappings.addMapping(300, configurations.getByName("api"), "compile");
        mavenScopeMappings.addMapping(300, configurations.getByName("compile"), "compile");
        mavenScopeMappings.addMapping(200, configurations.getByName("implementation"), "runtime");
        mavenScopeMappings.addMapping(150, configurations.getByName("testCompile"), "test");
        mavenScopeMappings.addMapping(100, configurations.getByName("testImplementation"), "test");
    }

    private void configureJavaScopeMappings(ConfigurationContainer configurations, Conf2ScopeMappingContainer mavenScopeMappings) {
        mavenScopeMappings.addMapping(300, configurations.getByName("compile"), "compile");
        mavenScopeMappings.addMapping(200, configurations.getByName("runtime"), "runtime");
        mavenScopeMappings.addMapping(200, configurations.getByName("implementation"), "runtime");
        mavenScopeMappings.addMapping(150, configurations.getByName("testCompile"), "test");
        mavenScopeMappings.addMapping(100, configurations.getByName("testRuntime"), "test");
        mavenScopeMappings.addMapping(100, configurations.getByName("testImplementation"), "test");
    }

    private void configureJavaLibraryScopeMappings(ConfigurationContainer configurations, Conf2ScopeMappingContainer mavenScopeMappings) {
        mavenScopeMappings.addMapping(300, configurations.getByName("api"), "compile");
    }

    private void configureWarScopeMappings(ConfigurationContainer configurations, Conf2ScopeMappingContainer mavenScopeMappings) {
        mavenScopeMappings.addMapping(400, configurations.getByName("providedCompile"), "provided");
        mavenScopeMappings.addMapping(450, configurations.getByName("providedRuntime"), "provided");
    }

    private void configureInstall(Project project) {
        Upload installUpload = (Upload)project.getTasks().create(INSTALL_TASK_NAME, Upload.class);
        Configuration configuration = project.getConfigurations().getByName("archives");
        installUpload.setConfiguration(configuration);
        MavenRepositoryHandlerConvention repositories = (MavenRepositoryHandlerConvention)new DslObject((Object)installUpload.getRepositories()).getConvention().getPlugin(MavenRepositoryHandlerConvention.class);
        repositories.mavenInstaller();
        installUpload.setDescription("Installs the 'archives' artifacts into the local Maven repository.");
    }
}

