/*
 * Decompiled with CFR 0.152.
 */
package com.ddphin.security.demo.system.id;

import com.ddphin.security.demo.system.id.SnowFlakeIDWorker;
import com.ddphin.security.demo.system.id.SnowFlakeIDWorkerFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class IDWorkerAware {
    private SnowFlakeIDWorker idWorker;

    @Autowired
    public void setIdWorker(SnowFlakeIDWorkerFactory snowFlakeIDWorkerFactory) {
        this.idWorker = snowFlakeIDWorkerFactory.newWorker();
    }

    protected long nextId() {
        return this.idWorker.nextId();
    }

    protected String nextIdWtihTimestampPrefix(String pattern, int digits, int radix) {
        return new SimpleDateFormat(pattern).format(new Date(System.currentTimeMillis())) + StringUtils.leftPad((String)Long.toString(this.nextId(), radix), (int)digits, (String)"0");
    }

    protected String nextIdWtihCustomizedPrefix(String prefix, int digits, int radix) {
        return prefix + StringUtils.leftPad((String)Long.toString(this.nextId(), radix), (int)digits, (String)"0");
    }

    protected String nextIdWtihCustomizedPrefix(long prefix, int prefixRadix, int prefixDigits, int digits, int radix) {
        return StringUtils.leftPad((String)Long.toString(prefix, prefixRadix), (int)prefixDigits, (String)"0") + StringUtils.leftPad((String)Long.toString(this.nextId(), radix), (int)digits, (String)"0");
    }
}

