/*
 * Decompiled with CFR 0.152.
 */
package com.ddphin.security.demo.system.id;

import com.ddphin.security.demo.system.id.NodeEnvironment;
import com.ddphin.security.demo.system.id.SnowFlakeIDWorkerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class NodeEnvironmentConfigurer {
    private static final Logger log = LoggerFactory.getLogger(NodeEnvironmentConfigurer.class);

    @Bean
    public NodeEnvironment nodeEnvironment(Environment environment) {
        NodeEnvironment env = new NodeEnvironment();
        Integer dataCenterId = Integer.valueOf(environment.getProperty("DATA_CENTER_ID", "0"));
        Integer workerId = Integer.valueOf(environment.getProperty("WORKER_ID", "0"));
        log.info("NodeEnvironment\n    DATA_CENTER_ID={}\n         WORKER_ID={}", (Object)dataCenterId, (Object)workerId);
        env.setDataCenterId(dataCenterId);
        env.setWorkerId(workerId);
        return env;
    }

    @Bean
    public SnowFlakeIDWorkerFactory snowFlakeIDWorkerFactory(NodeEnvironment nodeEnvironment) {
        return new SnowFlakeIDWorkerFactory(nodeEnvironment.getWorkerId().intValue(), nodeEnvironment.getDataCenterId().intValue());
    }
}

