/*
 * Decompiled with CFR 0.152.
 */
package com.ddphin.security.demo.system.id;

import com.ddphin.security.demo.system.id.SnowFlakeIDWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlakeIDWorkerFactory {
    private static final Logger log = LoggerFactory.getLogger(SnowFlakeIDWorkerFactory.class);
    private static final long workerIdBits = 5L;
    private static final long dataCenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDataCenterId = 31L;
    private long workerId;
    private long dataCenterId;

    public SnowFlakeIDWorkerFactory(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public SnowFlakeIDWorker newWorker() {
        return new SnowFlakeIDWorker(this.workerId, this.dataCenterId, 0L);
    }
}

