/*
 * Decompiled with CFR 0.152.
 */
package com.ddphin.security.demo.util;

import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class AESCryptor {
    public static final AESCryptor cryptor = new AESCryptor();
    private static boolean initialized = false;
    private static final String ALGORITHM_AES = "AES";
    private static final String PROVIDER_BC = "BC";
    private static final String TRANSFORMATION_AES_CBC_PKCS7PADDING = "AES/CBC/PKCS7Padding";

    public String decrypt(String content, String key, String iv) {
        return new String(Objects.requireNonNull(this.decrypt(Base64.decode((String)content), Base64.decode((String)key), Base64.decode((String)iv))), StandardCharsets.UTF_8);
    }

    private byte[] decrypt(byte[] content, byte[] keyByte, byte[] ivByte) {
        this.initialize();
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_AES_CBC_PKCS7PADDING, PROVIDER_BC);
            SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, ALGORITHM_AES);
            cipher.init(2, (Key)sKeySpec, this.generateIV(ivByte));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initialize() {
        if (!initialized) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            initialized = true;
        }
    }

    private AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance(ALGORITHM_AES);
        params.init(new IvParameterSpec(iv));
        return params;
    }
}

