/*
 * Decompiled with CFR 0.152.
 */
package com.ddphin.security.endpoint.service;

import com.ddphin.security.demo.system.redis.helper.RedisHelper;
import com.ddphin.security.endpoint.service.AJWTAbstractService;
import com.ddphin.security.entity.AIdentity;
import java.time.Duration;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DDphinAJWTService
extends AJWTAbstractService {
    private static final Integer JWT_EXPIRE_DAYS = 6;
    @Autowired
    private RedisHelper redisHelper;

    protected void saveToken(String id, String token) {
        Date now = DateTime.now().toDate();
        Date expireTime = DateTime.now().plusDays(JWT_EXPIRE_DAYS.intValue()).toDate();
        this.redisHelper.forValue().set((Object)id, (Object)token, Duration.ofMillis(expireTime.getTime() - now.getTime()));
    }

    protected void removeToken(String id) {
        this.redisHelper.redis().delete((Object)id);
    }

    protected String queryToken(String id) {
        return (String)this.redisHelper.forValue().get((Object)id);
    }

    protected String getJWTID(AIdentity identity) {
        return "_token_@uid=" + identity.getUserId();
    }
}

