/*
 * Decompiled with CFR 0.152.
 */
package com.ddphin.security.endpoint.service;

import com.alibaba.fastjson.JSONObject;
import com.ddphin.security.demo.mapper.APermissionMapper;
import com.ddphin.security.demo.mapper.AUserCredentialMapper;
import com.ddphin.security.demo.mapper.AUserIdentifierMapper;
import com.ddphin.security.demo.mapper.AUserSocialMapper;
import com.ddphin.security.demo.system.id.IDWorkerAware;
import com.ddphin.security.demo.system.redis.helper.RedisHelper;
import com.ddphin.security.endpoint.entity.ACredential;
import com.ddphin.security.endpoint.entity.AIdentifier;
import com.ddphin.security.endpoint.entity.APermission;
import com.ddphin.security.endpoint.entity.ASocial;
import com.ddphin.security.endpoint.entity.ASocialDetail;
import com.ddphin.security.endpoint.entity.SocialDetail;
import com.ddphin.security.endpoint.service.AuthenticationService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DDphinAuthenticationService
extends IDWorkerAware
implements AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(DDphinAuthenticationService.class);
    @Autowired
    private RedisHelper redisHelper;
    @Autowired
    private AUserCredentialMapper aUserCredentialMapper;
    @Autowired
    private AUserIdentifierMapper aUserIdentifierMapper;
    @Autowired
    private AUserSocialMapper aUserSocialMapper;
    @Autowired
    private APermissionMapper aPermissionMapper;

    public AIdentifier queryIdentifier(Integer identifierType, String identifierValue) {
        return this.aUserIdentifierMapper.query(identifierType, identifierValue);
    }

    public ACredential queryCredential(Long userId, Integer credentialType) {
        return this.aUserCredentialMapper.query(userId, credentialType);
    }

    public List<String> queryPermissionIdList(Long userId) {
        List<Long> list = this.aPermissionMapper.queryPermissionIdList(userId);
        return null == list ? null : list.stream().map(String::valueOf).collect(Collectors.toList());
    }

    public List<? extends APermission> queryAllPermission() {
        return this.aPermissionMapper.queryAllPermission();
    }

    public String queryValidCode(String mobile) {
        return (String)this.redisHelper.forValue().get((Object)("_valid_code_@mobile=" + mobile));
    }

    public void removeValidCode(String mobile) {
        this.redisHelper.redis().delete((Object)("_valid_code_@mobile=" + mobile));
    }

    public Long nextUserId() {
        return this.nextId();
    }

    public void saveUser(Long userId, String invitationCode, String mobile) {
        log.info("saveUser:\n    userId:{}\n    mobile:{}", (Object)userId, (Object)mobile);
    }

    public void saveUser(Long userId, String invitationCode, ASocialDetail socialInfo) {
        log.info("saveUser:\n    userId:{}\n    social:{}", (Object)userId, (Object)JSONObject.toJSONString((Object)socialInfo));
    }

    public void saveIdentifier(Long userId, Integer identifierType, String identifierValue) {
        this.aUserIdentifierMapper.insert(userId, identifierType, identifierValue);
    }

    public ASocial querySocial(Long userId, Integer identifierType, Integer socialType) {
        return this.aUserSocialMapper.query(userId, identifierType, socialType);
    }

    public void saveSocial(Long userId, Integer identifierType, Integer socialType, ASocialDetail socialInfo) {
        this.aUserSocialMapper.insert(userId, identifierType, socialType, (SocialDetail)socialInfo);
    }

    public void updateSocial(Long userId, Integer identifierType, Integer socialType, ASocialDetail socialInfo) {
        this.aUserSocialMapper.update(userId, identifierType, socialType, (SocialDetail)socialInfo);
    }

    public String[] getPermissiveUrl() {
        return new String[]{this.getLoginUrl(), this.getLogoutUrl(), "/tourist/**"};
    }
}

