/*
 * Decompiled with CFR 0.152.
 */
package com.github.deansquirrel.tools.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.deansquirrel.tools.db.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource {
    private final Logger logger = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private DynamicDataSourceContextHolder contextHolder = null;
    private Map<Object, Object> targetDataSources = null;

    private DynamicRoutingDataSource() {
    }

    public static DynamicRoutingDataSource createDynamicRoutingDataSource(DynamicDataSourceContextHolder contextHolder) {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setTargetDataSources(new HashMap<Object, Object>());
        dataSource.contextHolder = contextHolder;
        return dataSource;
    }

    protected Object determineCurrentLookupKey() {
        return this.contextHolder.getDataSourceKey();
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        this.targetDataSources = targetDataSources;
    }

    public boolean isExistDataSource(String key) {
        return this.targetDataSources.containsKey(key);
    }

    public int size() {
        return this.targetDataSources.size();
    }

    public synchronized void addDataSource(String key, DataSource dataSource) {
        this.logger.info("adding datasource {}", (Object)key);
        if (this.targetDataSources.containsKey(key)) {
            this.logger.warn("datasource {} is exists", (Object)key);
            return;
        }
        this.targetDataSources.put(key, dataSource);
        this.afterPropertiesSet();
        this.logger.info("datasource {} has been added", (Object)key);
    }

    public synchronized void removeDataSource(String key) {
        this.logger.info("removing datasource {}", (Object)key);
        DruidDataSource dataSource = (DruidDataSource)this.targetDataSources.get(key);
        if (this.targetDataSources.containsKey(key)) {
            this.targetDataSources.remove(key);
            dataSource.close();
            this.afterPropertiesSet();
        }
        this.logger.info("datasource {} has been removed", (Object)key);
    }

    public synchronized void setDataSourceKey(String key) {
        this.logger.debug("set current datasource {}", (Object)key);
        this.contextHolder.setDataSourceKey(key);
    }

    public synchronized void remove() {
        this.logger.debug("set current datasource default");
        this.contextHolder.remove();
    }

    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.targetDataSources.keySet()) {
            result.add(String.valueOf(key));
        }
        return result;
    }

    public synchronized void clear() {
        for (String key : this.keySet()) {
            this.removeDataSource(key);
        }
    }
}

