/*
 * Decompiled with CFR 0.152.
 */
package com.github.deansquirrel.tools.db;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.NonNull;

public interface IToolsDbHelper {
    public static final String BEAN_TX_MANAGER = "txManagerDynamic";
    public static final String BEAN_JDBC_TEMPLATE = "jdbcTemplateDynamic";
    public static final String DYNAMIC_ROUTEING_DATASOURCE = "dynamicRoutingDataSourceDynamic";
    public static final int DEFAULT_QUERY_TIMEOUT = 3600;
    public static final int DEFAULT_MAX_ACTIVE = 30;

    public JdbcTemplate getJdbcTemplate();

    public void addDataSource(@NonNull String var1, @NonNull DruidDataSource var2, Integer var3, Integer var4);

    default public void addDataSource(@NonNull String key, @NonNull DruidDataSource dataSource) {
        this.addDataSource(key, dataSource, 3600, 30);
    }

    public void removeDataSource(@NonNull String var1);

    public void clear();

    public long size();

    public void setDataSourceKey(@NonNull String var1);

    public void remove();

    default public void setSourceAttributes(DruidDataSource dataSource, Integer queryTimeout, Integer maxActive) {
        dataSource.setMinIdle(0);
        dataSource.setInitialSize(1);
        dataSource.setMaxActive(maxActive == null ? 30 : maxActive);
        dataSource.setMaxWait(10000L);
        dataSource.setQueryTimeout(queryTimeout == null ? 3600 : queryTimeout);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setTimeBetweenConnectErrorMillis(15000L);
        dataSource.setLoginTimeout(10);
        dataSource.setTestWhileIdle(true);
    }

    default public void setSourceAttributes(DruidDataSource dataSource) {
        this.setSourceAttributes(dataSource, 3600, 30);
    }
}

