/*
 * Decompiled with CFR 0.152.
 */
package com.github.deansquirrel.tools.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.deansquirrel.tools.db.DynamicRoutingDataSource;
import com.github.deansquirrel.tools.db.IToolsDbHelper;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class ToolsHelperImpl
implements IToolsDbHelper {
    private final JdbcTemplate jdbcTemplate;
    private final DynamicRoutingDataSource dynamicRoutingDataSource;

    public ToolsHelperImpl(@Qualifier(value="jdbcTemplateDynamic") JdbcTemplate jdbcTemplate, @Qualifier(value="dynamicRoutingDataSourceDynamic") DynamicRoutingDataSource dynamicRoutingDataSource) {
        this.jdbcTemplate = jdbcTemplate;
        this.dynamicRoutingDataSource = dynamicRoutingDataSource;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public void addDataSource(String key, DruidDataSource dataSource, Integer queryTimeout, Integer maxActive) {
        this.dynamicRoutingDataSource.addDataSource(key, (DataSource)dataSource);
    }

    @Override
    public void removeDataSource(String key) {
        this.dynamicRoutingDataSource.removeDataSource(key);
    }

    @Override
    public void clear() {
        this.dynamicRoutingDataSource.clear();
    }

    @Override
    public long size() {
        return this.dynamicRoutingDataSource.size();
    }

    @Override
    public void setDataSourceKey(String key) {
        this.dynamicRoutingDataSource.setDataSourceKey(key);
    }

    @Override
    public void remove() {
        this.dynamicRoutingDataSource.remove();
    }
}

