/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.github.developframework.kite.core.Framework;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.KiteOptions;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.element.Fragment;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.TemplateException;
import com.github.developframework.kite.core.exception.TemplatePackageUndefinedException;
import com.github.developframework.kite.core.node.ObjectNodeProxy;
import com.github.developframework.kite.core.strategy.NamingStrategy;
import com.github.developframework.kite.core.structs.TemplatePackage;
import com.github.developframework.kite.core.structs.TemplatePackageRegistry;
import java.util.Stack;

public final class AssembleContext {
    private final Stack<Object> valueStack = new Stack();
    private final Stack<ObjectNodeProxy> nodeStack = new Stack();
    private final KiteConfiguration configuration;
    private final boolean assembleJson;
    public DataModel dataModel;
    public int arrayIndex;
    public int arrayLength;
    public Stack<Fragment> slotStack = new Stack();
    public TemplatePackageRegistry extraTemplatePackages = new TemplatePackageRegistry();

    public AssembleContext(KiteConfiguration configuration, boolean assembleJson) {
        this.configuration = configuration;
        this.assembleJson = assembleJson;
    }

    public Framework<?> switchFramework() {
        return this.assembleJson ? this.configuration.getJsonFramework() : this.configuration.getXmlFramework();
    }

    public NamingStrategy getOptionNamingStrategy() {
        KiteOptions options = this.configuration.getOptions();
        return this.assembleJson ? options.getJson().getNamingStrategy() : options.getXml().getNamingStrategy();
    }

    public void pushNodeProxy(ObjectNodeProxy nodeProxy) {
        this.nodeStack.push(nodeProxy);
    }

    public void parentPutNodeProxyAndPush(String name) {
        this.nodeStack.push(this.nodeStack.peek().putObjectNode(name));
    }

    public ObjectNodeProxy peekNodeProxy() {
        return this.nodeStack.peek();
    }

    public void pushValue(Object value) {
        this.valueStack.push(value);
    }

    public void popNodeProxy() {
        this.nodeStack.pop();
    }

    public void popValue() {
        this.valueStack.pop();
    }

    public Object peekValue() {
        return this.valueStack.isEmpty() ? null : this.valueStack.peek();
    }

    public void pop() {
        this.nodeStack.pop();
        this.valueStack.pop();
    }

    public Template extractTemplate(String namespace, String id) {
        Template template = this.findTemplatePackage(namespace).getTemplateById(id);
        if (template == null) {
            throw new TemplateException("\u672a\u5b9a\u4e49\u6a21\u677f\u201c%s.%s\u201d", namespace, id);
        }
        return template;
    }

    public Fragment extractFragment(String namespace, String id) {
        Fragment fragment = (Fragment)this.findTemplatePackage(namespace).get(id);
        if (fragment == null) {
            throw new TemplateException("\u672a\u5b9a\u4e49\u7247\u6bb5\u201c%s.%s\u201d", namespace, id);
        }
        return fragment;
    }

    private TemplatePackage findTemplatePackage(String namespace) {
        TemplatePackageRegistry registry = this.configuration.getTemplatePackageRegistry();
        TemplatePackage templatePackage = registry.getTemplatePackageByNamespace(namespace);
        if (templatePackage == null && (templatePackage = this.extraTemplatePackages.getTemplatePackageByNamespace(namespace)) == null) {
            throw new TemplatePackageUndefinedException(namespace);
        }
        return templatePackage;
    }

    public KiteConfiguration getConfiguration() {
        return this.configuration;
    }
}

