/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.github.developframework.kite.core.Framework;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.Producer;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.parser.KtlParser;
import com.github.developframework.kite.core.source.StringConfigurationSource;
import com.github.developframework.kite.core.structs.TemplatePackage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class KiteFactory {
    private final KiteConfiguration configuration;
    private final KtlParser ktlParser;

    protected KiteFactory(KiteConfiguration configuration) {
        this.configuration = configuration;
        this.ktlParser = new KtlParser(configuration.getOptions().getKtlIndent());
    }

    public void useJsonFramework(Framework<?> framework) {
        this.configuration.setJsonFramework(framework);
    }

    public void useXmlFramework(Framework<?> framework) {
        this.configuration.setXmlFramework(framework);
    }

    public Producer getJsonProducer(DataModel dataModel, String namespace, String templateId) {
        Framework<?> framework = this.configuration.getJsonFramework();
        if (framework == null) {
            throw new KiteException("\u6ca1\u6709\u521d\u59cb\u5316\u5e8f\u5217\u5316Json\u7684Framework");
        }
        return framework.buildProducer(this.configuration, dataModel, namespace, templateId);
    }

    public Producer getJsonProducer(DataModel dataModel, String ktl) {
        Framework<?> framework = this.configuration.getJsonFramework();
        if (framework == null) {
            throw new KiteException("\u6ca1\u6709\u521d\u59cb\u5316\u5e8f\u5217\u5316Json\u7684Framework");
        }
        try {
            List<TemplatePackage> templatePackages = this.ktlParser.read(new StringConfigurationSource(ktl, StandardCharsets.UTF_8));
            return framework.buildProducer(this.configuration, dataModel, templatePackages);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KiteException("ktl\u89e3\u6790\u5931\u8d25");
        }
    }

    public Producer getXmlProducer(DataModel dataModel, String namespace, String templateId) {
        Framework<?> framework = this.configuration.getXmlFramework();
        if (framework == null) {
            throw new KiteException("\u6ca1\u6709\u521d\u59cb\u5316\u5e8f\u5217\u5316Xml\u7684Framework");
        }
        return framework.buildProducer(this.configuration, dataModel, namespace, templateId);
    }

    public Producer getXmlProducer(DataModel dataModel, String ktl) {
        Framework<?> framework = this.configuration.getXmlFramework();
        if (framework == null) {
            throw new KiteException("\u6ca1\u6709\u521d\u59cb\u5316\u5e8f\u5217\u5316Xml\u7684Framework");
        }
        try {
            List<TemplatePackage> templatePackages = this.ktlParser.read(new StringConfigurationSource(ktl, StandardCharsets.UTF_8));
            return framework.buildProducer(this.configuration, dataModel, templatePackages);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KiteException("ktl\u89e3\u6790\u5931\u8d25");
        }
    }

    public KiteConfiguration getConfiguration() {
        return this.configuration;
    }

    public KtlParser getKtlParser() {
        return this.ktlParser;
    }
}

