/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.KiteOptions;
import com.github.developframework.kite.core.exception.KiteParseException;
import com.github.developframework.kite.core.parser.KtlParser;
import com.github.developframework.kite.core.parser.Parser;
import com.github.developframework.kite.core.parser.XmlParser;
import com.github.developframework.kite.core.source.ClasspathConfigurationSource;
import com.github.developframework.kite.core.source.ConfigurationSource;
import com.github.developframework.kite.core.structs.TemplatePackageRegistry;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KiteFactoryBuilder {
    private static final Logger log = LoggerFactory.getLogger(KiteFactoryBuilder.class);

    public static KiteFactory build(KiteOptions options) {
        TemplatePackageRegistry registry = new TemplatePackageRegistry();
        return new KiteFactory(new KiteConfiguration(options, registry));
    }

    public static KiteFactory buildFromClasspathXml(KiteOptions options, String ... xmlFiles) {
        Set<ConfigurationSource> sources = Stream.of(xmlFiles).map(ClasspathConfigurationSource::new).collect(Collectors.toSet());
        return KiteFactoryBuilder.buildFromXml(options, sources);
    }

    public static KiteFactory buildFromXml(KiteOptions options, Set<ConfigurationSource> sources) {
        XmlParser parser = new XmlParser();
        return KiteFactoryBuilder.buildKiteFactory(options, parser, sources);
    }

    public static KiteFactory buildFromClasspathKtl(KiteOptions options, String ... ktlFiles) {
        Set<ConfigurationSource> sources = Stream.of(ktlFiles).map(ClasspathConfigurationSource::new).collect(Collectors.toSet());
        return KiteFactoryBuilder.buildFromKtl(options, sources);
    }

    public static KiteFactory buildFromKtl(KiteOptions options, Set<ConfigurationSource> sources) {
        KtlParser parser = new KtlParser(options.getKtlIndent());
        return KiteFactoryBuilder.buildKiteFactory(options, parser, sources);
    }

    private static KiteFactory buildKiteFactory(KiteOptions options, Parser parser, Set<ConfigurationSource> sources) {
        TemplatePackageRegistry registry = new TemplatePackageRegistry();
        sources.stream().flatMap(source -> {
            try {
                Stream stream = parser.read((ConfigurationSource)source).stream();
                return stream;
            }
            catch (IOException e) {
                throw new KiteParseException("\u89e3\u6790\u914d\u7f6e\u6e90\u201c%s\u201d\u53d1\u751f\u9519\u8bef\uff1a%s", source.getSourceName(), e.getMessage());
            }
            finally {
                log.debug("\u3010Kite\u3011\u5df2\u52a0\u8f7d\u914d\u7f6e\u6e90\u201c{}\u201d", (Object)source.getSourceName());
            }
        }).forEach(registry::putTemplatePackage);
        return new KiteFactory(new KiteConfiguration(options, registry));
    }
}

