/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.data;

import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.CaseTestFunction;
import com.github.developframework.kite.core.dynamic.KiteCondition;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.dynamic.RelFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DataModel {
    private final Map<String, Object> dataMap = new HashMap<String, Object>();

    public DataModel(Map<String, Object> dataMap) {
        this.dataMap.putAll(dataMap);
    }

    public DataModel putData(String dataName, Object data) {
        this.dataMap.put(dataName, data);
        return this;
    }

    public DataModel putConverter(String dataName, KiteConverter<?, ?> kiteConverter) {
        this.dataMap.put(dataName, kiteConverter);
        return this;
    }

    public DataModel putCondition(String dataName, KiteCondition<?> kiteCondition) {
        this.dataMap.put(dataName, kiteCondition);
        return this;
    }

    public DataModel putCaseTestFunction(String dataName, CaseTestFunction<?> caseTestFunction) {
        this.dataMap.put(dataName, caseTestFunction);
        return this;
    }

    public DataModel putRelFunction(String dataName, RelFunction<?, ?> relFunction) {
        this.dataMap.put(dataName, relFunction);
        return this;
    }

    public Optional<Object> getData(Expression expression) {
        return Optional.ofNullable(ExpressionUtils.getValue(this.dataMap, (Expression)expression));
    }

    public Optional<Object> getData(String expressionValue) {
        return this.getData(Expression.parse((String)expressionValue));
    }

    public static DataModel singleton(String dataName, Object data) {
        return new DataModel().putData(dataName, data);
    }

    public static DataModel builder() {
        return new DataModel();
    }

    public DataModel() {
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }
}

