/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.element.ContainerKiteElement;
import com.github.developframework.kite.core.node.ArrayNodeProxy;
import com.github.developframework.kite.core.structs.ArrayAttributes;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Optional;

@ElementAttributes(value={"map", "comparator", "limit", "null-empty", "xml-item"})
public class ArrayKiteElement
extends ContainerKiteElement {
    protected ArrayAttributes arrayAttributes;

    public ArrayKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.arrayAttributes = ArrayAttributes.of(elementDefinition);
    }

    @Override
    public void assemble(AssembleContext context) {
        Optional<Object> dataValue = KiteUtils.getDataValue(context, this);
        this.assembleWithArrayObject(context, dataValue.orElse(null));
    }

    public final void assembleWithArrayObject(AssembleContext context, Object arrayObj) {
        if (arrayObj != null) {
            ArrayNodeProxy arrayNodeProxy = context.peekNodeProxy().putArrayNode(this.displayName(context));
            this.assembleArrayItems(context, arrayObj, arrayNodeProxy);
        } else if (!this.contentAttributes.nullHidden) {
            if (this.arrayAttributes.nullEmpty) {
                context.peekNodeProxy().putArrayNode(this.displayName(context));
            } else {
                context.peekNodeProxy().putNull(this.displayName(context));
            }
        }
    }

    public final void assembleArrayItems(AssembleContext context, Object arrayObj, ArrayNodeProxy arrayNodeProxy) {
        Object[] array = KiteUtils.objectToArray(arrayObj, this.contentAttributes.dataDefinition);
        KiteUtils.handleArrayComparator(context.dataModel, this.arrayAttributes.comparatorValue, array);
        int parentLength = context.arrayLength;
        int parentIndex = context.arrayIndex;
        context.arrayLength = this.arrayAttributes.limit != null && this.arrayAttributes.limit < array.length ? this.arrayAttributes.limit : array.length;
        context.arrayIndex = 0;
        while (context.arrayIndex < context.arrayLength) {
            Object v = KiteUtils.handleKiteConverter(context.dataModel, this.arrayAttributes.mapValue, array[context.arrayIndex]);
            if (this.elements.isEmpty()) {
                arrayNodeProxy.addValue(this.arrayAttributes, v);
            } else {
                context.pushValue(v);
                context.pushNodeProxy(arrayNodeProxy.addObject(this.arrayAttributes, context));
                this.forEachAssemble(context);
                context.pop();
            }
            ++context.arrayIndex;
        }
        context.arrayLength = parentLength;
        context.arrayIndex = parentIndex;
    }
}

