/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.node.ObjectNodeProxy;
import com.github.developframework.kite.core.structs.FragmentLocation;
import java.util.HashSet;
import java.util.Set;

public class BooleanPropertyKiteElement
extends PropertyKiteElement {
    private static final Set<Class<?>> ACCEPT_CLASS_SET = new HashSet();

    public BooleanPropertyKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_SET.contains(sourceClass);
    }

    @Override
    protected void handle(ObjectNodeProxy parentNode, Object value, String displayName) {
        boolean v;
        Class<?> clazz = value.getClass();
        if (clazz == Boolean.class) {
            v = (Boolean)value;
        } else if (clazz == Integer.class) {
            v = (Integer)value != 0;
        } else if (clazz == Long.class) {
            v = (Long)value != 0L;
        } else if (clazz == Short.class) {
            v = (Short)value != 0;
        } else {
            parentNode.putNull(displayName);
            return;
        }
        parentNode.putValue(displayName, v, this.contentAttributes.xmlCDATA);
    }

    static {
        ACCEPT_CLASS_SET.add(Boolean.TYPE);
        ACCEPT_CLASS_SET.add(Boolean.class);
        ACCEPT_CLASS_SET.add(Integer.TYPE);
        ACCEPT_CLASS_SET.add(Integer.class);
        ACCEPT_CLASS_SET.add(Long.TYPE);
        ACCEPT_CLASS_SET.add(Long.class);
        ACCEPT_CLASS_SET.add(Short.TYPE);
        ACCEPT_CLASS_SET.add(Short.class);
    }
}

