/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.ElseKiteElement;
import com.github.developframework.kite.core.element.Fragment;
import com.github.developframework.kite.core.element.IfKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.SlotKiteElement;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ContainerKiteElement
extends ContentKiteElement
implements Iterable<KiteElement> {
    protected List<KiteElement> elements;

    public ContainerKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.elements = this.childrenElementLoadHandle(elementDefinition);
    }

    @Override
    public Iterator<KiteElement> iterator() {
        return this.elements.iterator();
    }

    public final void forEachAssemble(AssembleContext context) {
        for (KiteElement element : this.elements) {
            if (element instanceof SlotKiteElement) {
                if (context.slotStack.isEmpty()) continue;
                Fragment fragment = context.slotStack.pop();
                fragment.forEachAssemble(context);
                context.slotStack.push(fragment);
                continue;
            }
            element.assemble(context);
        }
    }

    protected List<KiteElement> childrenElementLoadHandle(ElementDefinition elementDefinition) {
        KiteElement previous = null;
        List<KiteElement> children = elementDefinition.getChildren();
        ArrayList<KiteElement> list = new ArrayList<KiteElement>(children.size());
        for (KiteElement child : children) {
            if (child instanceof ElseKiteElement) {
                if (!(previous instanceof IfKiteElement)) continue;
                ((IfKiteElement)previous).setElseKiteElement((ElseKiteElement)child);
                continue;
            }
            previous = child;
            list.add(child);
        }
        return Collections.unmodifiableList(list);
    }
}

