/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.MethodExpression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.Framework;
import com.github.developframework.kite.core.element.AbstractKiteElement;
import com.github.developframework.kite.core.strategy.KitePropertyNamingStrategy;
import com.github.developframework.kite.core.strategy.NamingStrategy;
import com.github.developframework.kite.core.structs.ContentAttributes;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import org.apache.commons.lang3.StringUtils;

@ElementAttributes(value={"data", "alias", "null-hidden", "converter", "naming-strategy", "xml-cdata"})
public abstract class ContentKiteElement
extends AbstractKiteElement {
    protected ContentAttributes contentAttributes;

    public ContentKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.contentAttributes = ContentAttributes.of(elementDefinition);
    }

    protected String displayName(AssembleContext context) {
        if (StringUtils.isNotEmpty((CharSequence)this.contentAttributes.alias)) {
            return this.contentAttributes.alias;
        }
        Framework<?> framework = context.switchFramework();
        NamingStrategy namingStrategy = this.contentAttributes.namingStrategy != null ? this.contentAttributes.namingStrategy : context.getOptionNamingStrategy();
        KitePropertyNamingStrategy propertyNamingStrategy = namingStrategy == NamingStrategy.FRAMEWORK ? framework.namingStrategy() : namingStrategy.getNamingStrategy();
        return propertyNamingStrategy.propertyDisplayName(framework, this.determineNameFromExpression());
    }

    private String determineNameFromExpression() {
        Expression expression = this.contentAttributes.dataDefinition.getExpression();
        if (expression instanceof ObjectExpression) {
            return ((ObjectExpression)expression).getPropertyName();
        }
        if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            return arrayExpression.getPropertyName() + "_" + arrayExpression.getIndex();
        }
        if (expression instanceof MethodExpression) {
            MethodExpression methodExpression = (MethodExpression)expression;
            return methodExpression.getMethodName();
        }
        throw new AssertionError();
    }

    public ContentAttributes getContentAttributes() {
        return this.contentAttributes;
    }
}

