/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.node.ObjectNodeProxy;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.time.DateFormatUtils;

@ElementAttributes(value={"pattern"})
public class DatePropertyKiteElement
extends PropertyKiteElement {
    private static final Set<Class<?>> ACCEPT_CLASS_SET = new HashSet();
    private String pattern;

    public DatePropertyKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.pattern = elementDefinition.getString("pattern", "yyyy-MM-dd HH:mm:ss");
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_SET.contains(sourceClass);
    }

    @Override
    protected void handle(ObjectNodeProxy parentNode, Object value, String displayName) {
        Date date = this.transformDate(value);
        if (date == null) {
            parentNode.putNull(displayName);
            return;
        }
        parentNode.putValue(displayName, DateFormatUtils.format((Date)date, (String)this.pattern), this.contentAttributes.xmlCDATA);
    }

    protected Date transformDate(Object value) {
        Class<?> clazz = value.getClass();
        Date date = null;
        if (clazz == Date.class) {
            date = (Date)value;
        } else if (clazz == java.sql.Date.class) {
            date = new Date(((java.sql.Date)value).getTime());
        } else if (clazz == Time.class) {
            date = new Date(((Time)value).getTime());
        } else if (clazz == Timestamp.class) {
            date = new Date(((Timestamp)value).getTime());
        } else if (clazz == LocalDateTime.class) {
            date = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == LocalDate.class) {
            LocalTime localTime = LocalTime.of(0, 0, 0, 0);
            LocalDateTime localDateTime = LocalDateTime.of((LocalDate)value, localTime);
            date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == LocalTime.class) {
            LocalDate localDate = LocalDate.now();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, (LocalTime)value);
            date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == Instant.class) {
            date = Date.from((Instant)value);
        }
        return date;
    }

    static {
        ACCEPT_CLASS_SET.add(Date.class);
        ACCEPT_CLASS_SET.add(Calendar.class);
        ACCEPT_CLASS_SET.add(java.sql.Date.class);
        ACCEPT_CLASS_SET.add(Time.class);
        ACCEPT_CLASS_SET.add(Timestamp.class);
        ACCEPT_CLASS_SET.add(LocalDate.class);
        ACCEPT_CLASS_SET.add(LocalDateTime.class);
        ACCEPT_CLASS_SET.add(LocalTime.class);
        ACCEPT_CLASS_SET.add(Instant.class);
    }
}

