/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ContainerKiteElement;
import com.github.developframework.kite.core.exception.InvalidAttributeException;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Optional;

@ElementAttributes(value={"id", "extend"})
public class Fragment
extends ContainerKiteElement {
    protected String id;
    protected FragmentLocation fragmentLocationExtend;

    public Fragment(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.id = elementDefinition.getString("id");
        this.fragmentLocationExtend = this.parseExtend(elementDefinition);
    }

    @Override
    public void assemble(AssembleContext context) {
        if (this.fragmentLocationExtend == null) {
            if (this.contentAttributes.dataDefinition == DataDefinition.EMPTY) {
                this.forEachAssemble(context);
            } else {
                Optional<Object> dataValue = KiteUtils.getDataValue(context, this);
                if (dataValue.isPresent()) {
                    context.pushValue(dataValue.get());
                    this.forEachAssemble(context);
                    context.pop();
                } else if (!this.contentAttributes.nullHidden) {
                    context.peekNodeProxy().putNull(this.displayName(context));
                }
            }
        } else {
            context.slotStack.push(this);
            context.extractFragment(this.fragmentLocationExtend.getNamespace(), this.fragmentLocationExtend.getFragmentId()).assemble(context);
            context.slotStack.pop();
        }
    }

    private FragmentLocation parseExtend(ElementDefinition elementDefinition) {
        String extend = elementDefinition.getString("extend");
        if (extend != null) {
            if (extend.matches("^(.+\\.)?.+$")) {
                String[] parts = extend.split("\\.");
                if (parts.length == 1) {
                    return new FragmentLocation(this.fragmentLocation.getNamespace(), parts[0]);
                }
                return new FragmentLocation(parts[0], parts[1]);
            }
            throw new InvalidAttributeException("extend", extend, "\u683c\u5f0f\u9519\u8bef");
        }
        return null;
    }

    public String getId() {
        return this.id;
    }
}

