/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.exception.LinkSizeNotEqualException;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Optional;

@ElementAttributes(value={"merge-parent"})
public final class LinkKiteElement
extends ArrayKiteElement {
    private boolean mergeParent;

    public LinkKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.mergeParent = elementDefinition.getBoolean("merge-parent", false);
    }

    @Override
    public void assemble(AssembleContext context) {
        Optional<Object> dataValue = KiteUtils.getDataValue(context, this);
        if (dataValue.isPresent()) {
            int length;
            Object[] array = KiteUtils.objectToArray(dataValue.get(), this.contentAttributes.dataDefinition);
            KiteUtils.handleArrayComparator(context.dataModel, this.arrayAttributes.comparatorValue, array);
            int n = length = this.arrayAttributes.limit != null && this.arrayAttributes.limit < array.length ? this.arrayAttributes.limit : array.length;
            if (length != context.arrayLength) {
                throw new LinkSizeNotEqualException(this.fragmentLocation, length, context.arrayLength);
            }
            Object v = KiteUtils.handleKiteConverter(context.dataModel, this.arrayAttributes.mapValue, array[context.arrayIndex]);
            if (this.elements.isEmpty()) {
                context.peekNodeProxy().putValue(this.displayName(context), v, this.contentAttributes.xmlCDATA);
            } else if (this.mergeParent) {
                context.pushValue(v);
                this.forEachAssemble(context);
                context.popValue();
            } else {
                context.parentPutNodeProxyAndPush(this.displayName(context));
                context.pushValue(v);
                this.forEachAssemble(context);
                context.pop();
            }
        } else if (!this.contentAttributes.nullHidden) {
            context.peekNodeProxy().putNull(this.displayName(context));
        }
    }
}

