/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.dynamic.RelFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@ElementAttributes(value={"rel", "type", "merge-parent", "unique", "inner-converter"})
public final class RelevanceKiteElement
extends ArrayKiteElement {
    private String relValue;
    private RelevanceType relevanceType;
    private boolean mergeParent;
    private boolean unique;
    private String innerConverterValue;

    public RelevanceKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.relValue = elementDefinition.getString("rel");
        this.relevanceType = elementDefinition.getEnum("type", RelevanceType.class, RelevanceType.AUTO);
        this.mergeParent = elementDefinition.getBoolean("merge-parent", false);
        this.unique = elementDefinition.getBoolean("unique", false);
        this.innerConverterValue = elementDefinition.getString("inner-converter");
    }

    @Override
    public void assemble(AssembleContext context) {
        Optional<Object> dataValue = KiteUtils.getDataValue(context, this);
        if (dataValue.isPresent()) {
            Object v = dataValue.get();
            if (!KiteUtils.objectIsArray(v)) {
                throw new KiteException("relevance\u7684data\u5fc5\u987b\u662farray\u6216List/Set");
            }
            List<Object> matches = KiteUtils.handleInnerKiteConverter(context.dataModel, this.innerConverterValue, this.relevanceMatch((Object[])v, context));
            int size = matches.size();
            switch (this.relevanceType) {
                case MULTIPLE: {
                    super.assembleWithArrayObject(context, matches);
                    break;
                }
                case SINGLE: {
                    this.assembleObject(context, size == 0 ? null : matches.get(0));
                    break;
                }
                case AUTO: {
                    if (size == 0) {
                        this.assembleObject(context, null);
                        break;
                    }
                    if (size == 1) {
                        this.assembleObject(context, matches.get(0));
                        break;
                    }
                    super.assembleWithArrayObject(context, matches);
                }
            }
        } else if (!this.contentAttributes.nullHidden) {
            context.peekNodeProxy().putNull(this.displayName(context));
        }
    }

    private void assembleObject(AssembleContext context, Object object) {
        if (this.mergeParent) {
            if (this.elements.isEmpty()) {
                context.peekNodeProxy().putValue(this.displayName(context), object, this.contentAttributes.xmlCDATA);
            } else {
                context.pushValue(object);
                this.forEachAssemble(context);
                context.popValue();
            }
        } else {
            context.parentPutNodeProxyAndPush(this.displayName(context));
            context.pushValue(object);
            this.forEachAssemble(context);
            context.pop();
        }
    }

    private List<Object> relevanceMatch(Object[] array, AssembleContext context) {
        Object parentValue = context.peekValue();
        RelFunction relFunction = KiteUtils.getComponent(context.dataModel, this.relValue, RelFunction.class, "rel");
        ArrayList<Object> matches = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (!relFunction.relevant(parentValue, context.arrayIndex, array[i], i)) continue;
            matches.add(array[i]);
            if (this.unique && !matches.isEmpty()) break;
        }
        return matches;
    }

    public static enum RelevanceType {
        AUTO,
        SINGLE,
        MULTIPLE;

    }
}

