/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.data.FunctionSign;
import com.github.developframework.kite.core.element.AbstractKiteElement;
import com.github.developframework.kite.core.element.CaseKiteElement;
import com.github.developframework.kite.core.element.DefaultKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.structs.ElementAttributes;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.FragmentLocation;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

@ElementAttributes(value={"check-data"})
public final class SwitchKiteElement
extends AbstractKiteElement {
    private DataDefinition checkData;
    private final List<CaseKiteElement> caseElements = new LinkedList<CaseKiteElement>();
    private DefaultKiteElement defaultElement;

    public SwitchKiteElement(FragmentLocation fragmentLocation) {
        super(fragmentLocation);
    }

    @Override
    public void configure(ElementDefinition elementDefinition) {
        super.configure(elementDefinition);
        this.checkData = elementDefinition.getDataDefinition("check-data");
        for (KiteElement child : elementDefinition.getChildren()) {
            if (child instanceof CaseKiteElement) {
                this.caseElements.add((CaseKiteElement)child);
                continue;
            }
            if (!(child instanceof DefaultKiteElement)) continue;
            this.defaultElement = (DefaultKiteElement)child;
        }
    }

    @Override
    public void assemble(AssembleContext context) {
        this.getCheckDataValue(context, context.peekValue()).ifPresent(v -> {
            boolean finish = false;
            for (CaseKiteElement caseElement : this.caseElements) {
                if (!caseElement.match(context, v)) continue;
                caseElement.assemble(context);
                finish = true;
                break;
            }
            if (!finish && this.defaultElement != null) {
                this.defaultElement.assemble(context);
            }
        });
    }

    private Optional<Object> getCheckDataValue(AssembleContext context, Object parentValue) {
        if (this.checkData == DataDefinition.EMPTY) {
            return Optional.ofNullable(parentValue);
        }
        if (this.checkData.getFunctionSign() == FunctionSign.ROOT || parentValue instanceof DataModel) {
            return context.dataModel.getData(this.checkData.getExpression());
        }
        return Optional.ofNullable(ExpressionUtils.getValue((Object)parentValue, (Expression)this.checkData.getExpression()));
    }
}

