/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.parser;

import com.github.developframework.kite.core.element.AbstractKiteElement;
import com.github.developframework.kite.core.element.Fragment;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.InvalidAttributeException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.exception.KiteParseException;
import com.github.developframework.kite.core.parser.Parser;
import com.github.developframework.kite.core.source.ConfigurationSource;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.ElementTag;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.structs.TemplatePackage;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class KtlParser
extends Parser {
    private final int indent;

    @Override
    public List<TemplatePackage> read(ConfigurationSource configurationSource) throws IOException {
        LinkedList<TemplatePackage> templatePackages = new LinkedList<TemplatePackage>();
        List<LineNode> lineNodes = this.readLineDatas(configurationSource);
        if (lineNodes.get((int)0).element.equals(ElementTag.TEMPLATE_PACKAGE.getTag())) {
            for (LineNode lineNode : lineNodes) {
                String namespace = lineNode.getAttributes().get("namespace");
                TemplatePackage templatePackage = new TemplatePackage(namespace);
                templatePackages.add(templatePackage);
                this.processFragment(templatePackage, lineNode.getChildren());
            }
        } else {
            TemplatePackage templatePackage = new TemplatePackage();
            templatePackages.add(templatePackage);
            this.processFragment(templatePackage, lineNodes);
        }
        return templatePackages;
    }

    private void processFragment(TemplatePackage templatePackage, List<LineNode> nodes) {
        for (LineNode node : nodes) {
            String id;
            if (node.element.equals(ElementTag.TEMPLATE.getTag())) {
                id = node.getAttributes().get("id");
                templatePackage.push((Template)this.readKiteElement(node, new FragmentLocation(templatePackage.getNamespace(), id)));
                continue;
            }
            if (!node.element.equals(ElementTag.FRAGMENT.getTag())) continue;
            id = node.getAttributes().get("id");
            templatePackage.push((Fragment)this.readKiteElement(node, new FragmentLocation(templatePackage.getNamespace(), id)));
        }
    }

    private KiteElement readKiteElement(LineNode node, FragmentLocation fragmentLocation) {
        AbstractKiteElement kiteElement;
        this.checkAttributes(node);
        Class clazz = (Class)this.kiteElementClasses.get(node.getElement());
        List<KiteElement> children = this.childrenElements(node, fragmentLocation);
        try {
            kiteElement = (AbstractKiteElement)clazz.getConstructor(FragmentLocation.class).newInstance(fragmentLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KiteException("KTL\u89e3\u6790\u5931\u8d25\uff0c\u9519\u8bef\u4f4d\u7f6e\u5728\"%s\"", fragmentLocation);
        }
        kiteElement.configure(new ElementDefinition(node.getAttributes(), children));
        return kiteElement;
    }

    private List<KiteElement> childrenElements(LineNode node, FragmentLocation fragmentLocation) {
        return node.getChildren().stream().map(n -> this.readKiteElement((LineNode)n, fragmentLocation)).collect(Collectors.toList());
    }

    private List<LineNode> readLineDatas(ConfigurationSource configurationSource) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(configurationSource.getInputStream()));
        LinkedList<LineNode> roots = new LinkedList<LineNode>();
        HashMap<Integer, LineNode> lastMap = new HashMap<Integer, LineNode>();
        Integer startLevel = null;
        while ((line = reader.readLine()) != null) {
            if (StringUtils.isBlank((CharSequence)line) || line.matches("^\\s*#")) continue;
            LineNode node = new LineNode(line);
            int level = node.getLevel();
            if (startLevel == null) {
                startLevel = level;
            }
            if (level == startLevel) {
                roots.add(node);
            }
            lastMap.computeIfPresent(level - 1, (k, v) -> {
                v.getChildren().add(node);
                return v;
            });
            lastMap.put(level, node);
        }
        return roots;
    }

    private void checkAttributes(LineNode node) {
        Set<String> validAttributes = ElementTag.of(node.getElement()).getValidAttributes();
        Set<String> attributes = node.attributes.keySet();
        for (String attribute : attributes) {
            if (validAttributes.contains(attribute)) continue;
            throw new InvalidAttributeException(attribute, node.attributes.get(attribute), "\u4e0d\u5408\u6cd5\u7684\u5c5e\u6027");
        }
    }

    public KtlParser(int indent) {
        this.indent = indent;
    }

    private final class LineNode {
        private int level;
        private String element;
        private Map<String, String> attributes = new HashMap<String, String>();
        private List<LineNode> children = new LinkedList<LineNode>();

        protected LineNode(String line) {
            this.level = this.computeLevel(line);
            String[] parts = line.trim().split("\\s*:\\s*");
            this.element = parts[0];
            if (parts.length > 1) {
                String[] parameterStrs;
                for (String str : parameterStrs = parts[1].split("\\s*,\\s*")) {
                    String[] kv = str.split("\\s*=\\s*");
                    if (kv.length != 2) {
                        throw new KiteException("ktl\u683c\u5f0f\u9519\u8bef\u201c%s\u201d", line);
                    }
                    String literal = KiteUtils.getLiteral(kv[1]);
                    this.attributes.put(kv[0], literal == null ? kv[1] : literal);
                }
            }
        }

        private int computeLevel(String line) {
            char c;
            int ind = 0;
            int length = line.length();
            for (int i = 0; i < length && (c = line.charAt(i)) == ' '; ++i) {
                ++ind;
            }
            if (ind % KtlParser.this.indent == 0) {
                return ind / KtlParser.this.indent;
            }
            throw new KiteParseException("ktl\u89e3\u6790\u5931\u8d25\uff0c\u884c\u201c%s\u201d\u7f29\u8fdb\u9519\u8bef\uff1a%d", line, ind);
        }

        public int getLevel() {
            return this.level;
        }

        public String getElement() {
            return this.element;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public List<LineNode> getChildren() {
            return this.children;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setElement(String element) {
            this.element = element;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public void setChildren(List<LineNode> children) {
            this.children = children;
        }
    }
}

