/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.parser;

import com.github.developframework.kite.core.element.AbstractKiteElement;
import com.github.developframework.kite.core.element.Fragment;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.parser.Parser;
import com.github.developframework.kite.core.source.ConfigurationSource;
import com.github.developframework.kite.core.structs.ElementDefinition;
import com.github.developframework.kite.core.structs.ElementTag;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.structs.TemplatePackage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class XmlParser
extends Parser {
    @Override
    public List<TemplatePackage> read(ConfigurationSource configurationSource) throws IOException {
        Document document;
        LinkedList<TemplatePackage> templatePackages = new LinkedList<TemplatePackage>();
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(configurationSource.getInputStream());
        }
        catch (DocumentException e) {
            throw new KiteException("XML\u89e3\u6790\u5931\u8d25\uff1a%s", e.getMessage());
        }
        Element rootElement = document.getRootElement();
        List templatePackageElements = rootElement.elements(ElementTag.TEMPLATE_PACKAGE.getTag());
        for (Element element : templatePackageElements) {
            String id;
            String namespace = element.attributeValue("namespace");
            TemplatePackage templatePackage = new TemplatePackage(namespace);
            for (Element templateElement : element.elements(ElementTag.TEMPLATE.getTag())) {
                id = templateElement.attributeValue("id");
                templatePackage.push((Template)this.readKiteElement(templateElement, new FragmentLocation(namespace, id)));
            }
            for (Element fragmentElement : element.elements(ElementTag.FRAGMENT.getTag())) {
                id = fragmentElement.attributeValue("id");
                templatePackage.push((Fragment)this.readKiteElement(fragmentElement, new FragmentLocation(namespace, id)));
            }
            templatePackages.add(templatePackage);
        }
        return templatePackages;
    }

    private KiteElement readKiteElement(Element element, FragmentLocation fragmentLocation) {
        AbstractKiteElement kiteElement;
        List<KiteElement> children = this.childrenElements(element, fragmentLocation);
        Class clazz = (Class)this.kiteElementClasses.get(element.getName());
        try {
            kiteElement = (AbstractKiteElement)clazz.getConstructor(FragmentLocation.class).newInstance(fragmentLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KiteException("XML\u89e3\u6790\u5931\u8d25\uff0c\u9519\u8bef\u4f4d\u7f6e\u5728\"%s\"", fragmentLocation);
        }
        Map<String, String> attributesMap = this.attributesMap(element);
        kiteElement.configure(new ElementDefinition(attributesMap, children));
        return kiteElement;
    }

    private Map<String, String> attributesMap(Element element) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterator = element.attributeIterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            map.put(attribute.getName(), attribute.getValue());
        }
        return map;
    }

    private List<KiteElement> childrenElements(Element element, FragmentLocation fragmentLocation) {
        return element.elements().stream().map(e -> this.readKiteElement((Element)e, fragmentLocation)).collect(Collectors.toList());
    }
}

