/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.source;

import com.github.developframework.kite.core.exception.ConfigurationSourceException;
import com.github.developframework.kite.core.source.ConfigurationSource;
import java.io.InputStream;

public class ClasspathConfigurationSource
implements ConfigurationSource {
    private final String filename;

    public ClasspathConfigurationSource(String filename) {
        this.filename = filename.startsWith("/") ? filename : "/" + filename;
    }

    @Override
    public InputStream getInputStream() {
        InputStream is = this.getClass().getResourceAsStream(this.filename);
        if (is == null) {
            throw new ConfigurationSourceException(this.filename);
        }
        return is;
    }

    @Override
    public String getSourceName() {
        return this.filename;
    }
}

