/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.structs;

import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.KiteElement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ElementDefinition {
    private final Map<String, String> attributes;
    private final List<KiteElement> children;

    public boolean getBoolean(String attributeName, boolean defaultValue) {
        String value = this.getString(attributeName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public DataDefinition getDataDefinition(String attributeName) {
        String data = this.getString(attributeName);
        return data == null ? DataDefinition.EMPTY : new DataDefinition(data);
    }

    public String getString(String attributeName) {
        String value = this.attributes.get(attributeName);
        return value == null ? null : value.trim();
    }

    public String getString(String attributeName, String defaultValue) {
        String value = this.getString(attributeName);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value.trim();
    }

    public Integer getInteger(String attributeName) {
        String value = this.getString(attributeName);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public int getInteger(String attributeName, int defaultValue) {
        Integer value = this.getInteger(attributeName);
        return value == null ? defaultValue : value;
    }

    public <T extends Enum<T>> T getEnum(String attributeName, Class<T> enumClass) {
        String value = this.getString(attributeName);
        return value == null ? null : (T)Enum.valueOf(enumClass, value.toUpperCase(Locale.ROOT).trim());
    }

    public <T extends Enum<T>> T getEnum(String attributeName, Class<T> enumClass, T defaultValue) {
        T value = this.getEnum(attributeName, enumClass);
        return value == null ? defaultValue : value;
    }

    public ElementDefinition(Map<String, String> attributes, List<KiteElement> children) {
        this.attributes = attributes;
        this.children = children;
    }

    public List<KiteElement> getChildren() {
        return this.children;
    }

    public static interface Attribute {
        public static final String DATA = "data";
        public static final String NAMESPACE = "namespace";
        public static final String ID = "id";
        public static final String ALIAS = "alias";
        public static final String CONVERTER = "converter";
        public static final String INNER_CONVERTER = "inner-converter";
        public static final String COMPARATOR = "comparator";
        public static final String LIMIT = "limit";
        public static final String MAP = "map";
        public static final String REL = "rel";
        public static final String TYPE = "type";
        public static final String NULL_HIDDEN = "null-hidden";
        public static final String NULL_EMPTY = "null-empty";
        public static final String ENUM_VALUE = "value";
        public static final String ENUM_TEXT = "text";
        public static final String MERGE_PARENT = "merge-parent";
        public static final String UNIQUE = "unique";
        public static final String CONDITION = "condition";
        public static final String CHECK_DATA = "check-data";
        public static final String CASE_TEST = "test";
        public static final String PATTERN = "pattern";
        public static final String EXTEND = "extend";
        public static final String CHILDREN_NAMING_STRATEGY = "children-naming-strategy";
        public static final String NAMING_STRATEGY = "naming-strategy";
        public static final String XML_ROOT = "xml-root";
        public static final String XML_ITEM = "xml-item";
        public static final String XML_CDATA = "xml-cdata";
    }
}

