/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.structs;

import com.github.developframework.kite.core.element.AbstractKiteElement;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.BooleanPropertyKiteElement;
import com.github.developframework.kite.core.element.CaseKiteElement;
import com.github.developframework.kite.core.element.DatePropertyKiteElement;
import com.github.developframework.kite.core.element.DefaultKiteElement;
import com.github.developframework.kite.core.element.ElseKiteElement;
import com.github.developframework.kite.core.element.EnumPropertyKiteElement;
import com.github.developframework.kite.core.element.EnumValueKiteElement;
import com.github.developframework.kite.core.element.FlatKiteElement;
import com.github.developframework.kite.core.element.Fragment;
import com.github.developframework.kite.core.element.IfKiteElement;
import com.github.developframework.kite.core.element.IncludeKiteElement;
import com.github.developframework.kite.core.element.LinkKiteElement;
import com.github.developframework.kite.core.element.NormalPropertyKiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.element.PrototypeKiteElement;
import com.github.developframework.kite.core.element.RawKiteElement;
import com.github.developframework.kite.core.element.RelevanceKiteElement;
import com.github.developframework.kite.core.element.SlotKiteElement;
import com.github.developframework.kite.core.element.SwitchKiteElement;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.element.ThisKiteElement;
import com.github.developframework.kite.core.element.UnixTimestampPropertyKiteElement;
import com.github.developframework.kite.core.element.VirtualObjectKiteElement;
import com.github.developframework.kite.core.element.XmlAttributeKiteElement;
import com.github.developframework.kite.core.structs.ElementAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ElementTag {
    IF("if", IfKiteElement.class),
    RAW("raw", RawKiteElement.class),
    LINK("link", LinkKiteElement.class),
    ELSE("else", ElseKiteElement.class),
    CASE("case", CaseKiteElement.class),
    SLOT("slot", SlotKiteElement.class),
    THIS("this", ThisKiteElement.class),
    FLAT("flat", FlatKiteElement.class),
    TEMPLATE("template", Template.class),
    FRAGMENT("fragment", Fragment.class),
    ARRAY("array", ArrayKiteElement.class),
    OBJECT("object", ObjectKiteElement.class),
    SWITCH("switch", SwitchKiteElement.class),
    INCLUDE("include", IncludeKiteElement.class),
    DEFAULT("default", DefaultKiteElement.class),
    ENUM_VALUE("enum", EnumValueKiteElement.class),
    RELEVANCE("relevance", RelevanceKiteElement.class),
    PROTOTYPE("prototype", PrototypeKiteElement.class),
    TEMPLATE_PACKAGE("template-package", null),
    PROPERTY("property", NormalPropertyKiteElement.class),
    PROPERTY_DATE("property-date", DatePropertyKiteElement.class),
    PROPERTY_ENUM("property-enum", EnumPropertyKiteElement.class),
    XML_ATTRIBUTE("xml-attribute", XmlAttributeKiteElement.class),
    OBJECT_VIRTUAL("object-virtual", VirtualObjectKiteElement.class),
    PROPERTY_BOOLEAN("property-boolean", BooleanPropertyKiteElement.class),
    PROPERTY_UNIXTIMESTAMP("property-unixtimestamp", UnixTimestampPropertyKiteElement.class);

    private final String tag;
    private final Class<? extends AbstractKiteElement> elementClass;
    private final Set<String> validAttributes;

    private ElementTag(String tag, Class<? extends AbstractKiteElement> elementClass) {
        this.tag = tag;
        this.elementClass = elementClass;
        this.validAttributes = ElementTag.getValidAttributes(elementClass);
    }

    public static Map<String, Class<? extends AbstractKiteElement>> buildMap() {
        HashMap<String, Class<? extends AbstractKiteElement>> map = new HashMap<String, Class<? extends AbstractKiteElement>>();
        for (ElementTag tag : ElementTag.values()) {
            if (tag.getElementClass() == null) continue;
            map.put(tag.getTag(), tag.getElementClass());
        }
        return map;
    }

    private static Set<String> getValidAttributes(Class<? extends AbstractKiteElement> clazz) {
        if (clazz == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        while (clazz != AbstractKiteElement.class) {
            ElementAttributes annotation = clazz.getAnnotation(ElementAttributes.class);
            if (annotation != null) {
                set.addAll(Arrays.asList(annotation.value()));
                set.addAll(ElementTag.getValidAttributes(annotation.baseClass()));
            }
            clazz = clazz.getSuperclass();
        }
        return set;
    }

    public static ElementTag of(String tag) {
        for (ElementTag elementTag : ElementTag.values()) {
            if (!elementTag.getTag().equals(tag)) continue;
            return elementTag;
        }
        throw new AssertionError();
    }

    public String getTag() {
        return this.tag;
    }

    public Class<? extends AbstractKiteElement> getElementClass() {
        return this.elementClass;
    }

    public Set<String> getValidAttributes() {
        return this.validAttributes;
    }
}

