/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.structs;

import com.github.developframework.kite.core.element.Fragment;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.exception.ResourceNotUniqueException;
import java.util.HashMap;

public class TemplatePackage
extends HashMap<String, Fragment> {
    public static final String DEFAULT_NAMESPACE = "_default";
    private String namespace;

    public TemplatePackage(String namespace) {
        this.namespace = namespace;
    }

    public TemplatePackage() {
        this.namespace = DEFAULT_NAMESPACE;
    }

    public Template getTemplateById(String templateId) {
        Fragment fragment = (Fragment)super.get(templateId);
        if (fragment instanceof Template) {
            return (Template)fragment;
        }
        return null;
    }

    public void push(Fragment fragment) {
        String templateId = fragment.getFragmentLocation().getFragmentId();
        if (super.containsKey(templateId)) {
            throw new ResourceNotUniqueException("template id", templateId);
        }
        super.put(templateId, fragment);
    }

    public Template getUniqueTemplate() {
        Template[] templates = (Template[])this.values().stream().filter(f -> f instanceof Template).map(f -> (Template)f).toArray(Template[]::new);
        if (templates.length != 1) {
            throw new KiteException("\u4f7f\u7528ktl\u6a21\u5f0f\u4e0btemplate-package\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2atemplate");
        }
        return templates[0];
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

