/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.structs;

import com.github.developframework.kite.core.exception.ResourceNotUniqueException;
import com.github.developframework.kite.core.structs.TemplatePackage;
import java.util.HashMap;
import java.util.Map;

public final class TemplatePackageRegistry {
    private final Map<String, TemplatePackage> templatePackages = new HashMap<String, TemplatePackage>();

    public void putTemplatePackage(TemplatePackage templatePackage) {
        String namespace = templatePackage.getNamespace();
        if (this.templatePackages.containsKey(namespace)) {
            throw new ResourceNotUniqueException("kite-package namespace", namespace);
        }
        this.templatePackages.put(namespace, templatePackage);
    }

    public TemplatePackage getTemplatePackageByNamespace(String namespace) {
        return this.templatePackages.get(namespace);
    }

    public void mergeTemplatePackage(TemplatePackage templatePackage) {
        TemplatePackage tp = this.templatePackages.get(templatePackage.getNamespace());
        if (tp == null) {
            this.templatePackages.put(templatePackage.getNamespace(), templatePackage);
        } else {
            templatePackage.values().forEach(tp::push);
        }
    }
}

