/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.utils;

import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.data.FunctionSign;
import com.github.developframework.kite.core.dynamic.CaseTestFunction;
import com.github.developframework.kite.core.dynamic.KiteCondition;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.exception.InvalidAttributeException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.structs.ContentAttributes;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiteUtils {
    private static final Logger log = LoggerFactory.getLogger(KiteUtils.class);

    public static Optional<Object> getDataValue(AssembleContext context, ContentKiteElement element) {
        ContentAttributes contentAttributes = element.getContentAttributes();
        DataDefinition dataDefinition = contentAttributes.dataDefinition;
        Object v = context.peekValue();
        v = v instanceof DataModel || dataDefinition.getFunctionSign() == FunctionSign.ROOT ? context.dataModel.getData(dataDefinition.getExpression()).orElse(null) : ExpressionUtils.getValue((Object)v, (Expression)dataDefinition.getExpression());
        return Optional.ofNullable(KiteUtils.handleKiteConverter(context.dataModel, contentAttributes.converterValue, v));
    }

    public static <T> T getComponent(DataModel dataModel, String value, Class<T> tClass, String attributeName) {
        return (T)dataModel.getData(value).orElseGet(() -> {
            try {
                Object obj = Class.forName(value).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (tClass.isAssignableFrom(obj.getClass())) {
                    return obj;
                }
                throw new InvalidAttributeException(attributeName, value, "\u6ca1\u6709\u7c7b\u201c" + tClass.getSimpleName() + "\u201d\u7684\u5b9e\u4f8b");
            }
            catch (ClassNotFoundException e) {
                throw new InvalidAttributeException(attributeName, value, "\u7c7b\u4e0d\u5b58\u5728\uff0c\u5e76\u4e14\u4e5f\u4e0d\u662f\u4e00\u4e2aexpression");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KiteException("\u4e0d\u80fdnew\u201c" + tClass.getSimpleName() + "\u201d\u7684\u5b9e\u4f8b");
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new KiteException(tClass.getSimpleName() + "\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u65b9\u6cd5");
            }
        });
    }

    public static boolean objectIsArray(Object object) {
        return object != null && (object.getClass().isArray() || object instanceof List || object instanceof Set);
    }

    public static Object[] objectToArray(Object object, DataDefinition dataDefinition) {
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        if (object instanceof List) {
            return ((List)object).toArray();
        }
        if (object instanceof Set) {
            return ((Set)object).toArray();
        }
        throw new InvalidAttributeException("data", dataDefinition.toString(), "data\u5fc5\u987b\u662farray\u6216List/Set\u7c7b\u578b\uff0c\u5f53\u524d\u7c7b\u4e3a" + object.getClass().getName());
    }

    public static Object handleKiteConverter(DataModel dataModel, String converterValue, Object value) {
        if (converterValue == null) {
            return value;
        }
        if (converterValue.startsWith("this.")) {
            return ExpressionUtils.getValue((Object)value, (String)converterValue.substring(5));
        }
        return KiteUtils.getComponent(dataModel, converterValue, KiteConverter.class, "converter").convert(value);
    }

    public static List<Object> handleInnerKiteConverter(DataModel dataModel, String innerConverterValue, List<Object> values) {
        if (innerConverterValue == null) {
            return values;
        }
        if (innerConverterValue.startsWith("this.")) {
            String field = innerConverterValue.substring(5);
            return values.stream().map(v -> ExpressionUtils.getValue((Object)v, (String)field)).collect(Collectors.toList());
        }
        KiteConverter converter = KiteUtils.getComponent(dataModel, innerConverterValue, KiteConverter.class, "converter");
        return values.stream().map(converter::convert).collect(Collectors.toList());
    }

    public static boolean handleCastTest(DataModel dataModel, String caseTestFunctionValue, Object value) {
        String literal = KiteUtils.getLiteral(caseTestFunctionValue);
        if (literal != null) {
            return Objects.equals(value == null ? null : value.toString(), literal);
        }
        return KiteUtils.getComponent(dataModel, caseTestFunctionValue, CaseTestFunction.class, "test").test(value);
    }

    public static void handleArrayComparator(DataModel dataModel, String comparatorValue, Object[] array) {
        if (comparatorValue != null) {
            Arrays.sort(array, KiteUtils.getComponent(dataModel, comparatorValue, Comparator.class, "comparator"));
        }
    }

    public static boolean handleCondition(DataModel dataModel, String conditionValue, Object parentValue) {
        return KiteUtils.getComponent(dataModel, conditionValue, KiteCondition.class, "condition").verify(dataModel, parentValue);
    }

    private static boolean isLiteral(String content) {
        return content != null && content.length() > 3 && content.charAt(0) == '\'' && content.charAt(content.length() - 1) == '\'';
    }

    public static String getLiteral(String content) {
        return KiteUtils.isLiteral(content) ? content.substring(1, content.length() - 1) : null;
    }
}

