/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.gson;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.node.ArrayNodeProxy;
import com.github.developframework.kite.core.node.ObjectNodeProxy;
import com.github.developframework.kite.core.structs.ArrayAttributes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;

public final class GsonArrayNodeProxy
implements ArrayNodeProxy {
    private final JsonArray node;

    public void addValue(ArrayAttributes arrayAttributes, Object value) {
        if (value == null) {
            this.node.add((JsonElement)JsonNull.INSTANCE);
        } else if (value instanceof String) {
            this.node.add((String)value);
        } else if (value instanceof Number) {
            this.node.add((Number)value);
        } else if (value instanceof Boolean) {
            this.node.add((Boolean)value);
        } else {
            this.node.add(value.toString());
        }
    }

    public ObjectNodeProxy addObject(ArrayAttributes arrayAttributes, AssembleContext context) {
        ObjectNodeProxy objectNodeProxy = context.createObjectNodeProxy();
        this.node.add((JsonElement)((JsonObject)objectNodeProxy.getNode()));
        return objectNodeProxy;
    }

    public ArrayNodeProxy addArray(ArrayAttributes arrayAttributes, AssembleContext context) {
        ArrayNodeProxy arrayNodeProxy = context.createArrayNodeProxy();
        this.node.add((JsonElement)((JsonArray)arrayNodeProxy.getNode()));
        return arrayNodeProxy;
    }

    public GsonArrayNodeProxy(JsonArray node) {
        this.node = node;
    }

    public JsonArray getNode() {
        return this.node;
    }
}

