/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.gson;

import com.github.developframework.kite.core.Framework;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.Producer;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.strategy.KitePropertyNamingStrategy;
import com.github.developframework.kite.core.strategy.NamingStrategy;
import com.github.developframework.kite.core.structs.TemplatePackage;
import com.github.developframework.kite.gson.GsonProducer;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class GsonFramework
implements Framework<Gson> {
    private final Gson gson;

    public GsonFramework() {
        this.gson = new GsonBuilder().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setDateFormat("yyyy-MM-dd HH:mm:ss").registerTypeAdapter(LocalDateTime.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))).registerTypeAdapter(LocalDate.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))).create();
    }

    public KitePropertyNamingStrategy namingStrategy() {
        return NamingStrategy.UNDERLINE.getNamingStrategy();
    }

    public Gson getCore() {
        return this.gson;
    }

    public Producer buildProducer(KiteConfiguration configuration, DataModel dataModel, String namespace, String templateId) {
        return new GsonProducer(configuration, dataModel, namespace, templateId);
    }

    public Producer buildProducer(KiteConfiguration configuration, DataModel dataModel, List<TemplatePackage> templatePackages) {
        return new GsonProducer(configuration, dataModel, templatePackages);
    }

    public GsonFramework(Gson gson) {
        this.gson = gson;
    }
}

