/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.gson;

import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.node.ArrayNodeProxy;
import com.github.developframework.kite.core.node.ObjectNodeProxy;
import com.github.developframework.kite.gson.GsonArrayNodeProxy;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public final class GsonObjectNodeProxy
implements ObjectNodeProxy {
    private final JsonObject node;

    public ObjectNodeProxy putObjectNode(String name) {
        JsonObject jsonObject = new JsonObject();
        this.node.add(name, (JsonElement)jsonObject);
        return new GsonObjectNodeProxy(jsonObject);
    }

    public ArrayNodeProxy putArrayNode(String name) {
        JsonArray jsonArray = new JsonArray();
        this.node.add(name, (JsonElement)jsonArray);
        return new GsonArrayNodeProxy(jsonArray);
    }

    public void putRaw(AssembleContext context, String name, String raw) {
        this.node.add(name, JsonParser.parseString((String)raw));
    }

    public void putPrototype(AssembleContext context, String name, Object prototype) {
        Gson gson = (Gson)context.configuration.getJsonFramework().getCore();
        JsonElement jsonElement = gson.toJsonTree(prototype);
        this.node.add(name, jsonElement);
    }

    public void putValue(String name, Object value, boolean xmlCDATA) {
        if (value instanceof String) {
            this.node.addProperty(name, (String)value);
        } else if (value instanceof Number) {
            this.node.addProperty(name, (Number)value);
        } else if (value instanceof Boolean) {
            this.node.addProperty(name, (Boolean)value);
        } else {
            this.node.addProperty(name, value.toString());
        }
    }

    public void putNull(String name) {
        this.node.add(name, (JsonElement)JsonNull.INSTANCE);
    }

    public GsonObjectNodeProxy(JsonObject node) {
        this.node = node;
    }

    public JsonObject getNode() {
        return this.node;
    }
}

