/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.gson;

import com.github.developframework.kite.core.AbstractProducer;
import com.github.developframework.kite.core.AssembleContext;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.node.NodeProxy;
import com.github.developframework.kite.core.structs.TemplatePackage;
import com.github.developframework.kite.gson.GsonAssembleContext;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

public final class GsonProducer
extends AbstractProducer {
    private final Gson gson;

    public GsonProducer(KiteConfiguration configuration, DataModel dataModel, String namespace, String templateId) {
        super(configuration, dataModel, namespace, templateId);
        this.gson = (Gson)configuration.getJsonFramework().getCore();
    }

    public GsonProducer(KiteConfiguration configuration, DataModel dataModel, List<TemplatePackage> templatePackages) {
        super(configuration, dataModel, templatePackages);
        this.gson = (Gson)configuration.getJsonFramework().getCore();
    }

    protected AssembleContext buildAssembleContext(DataModel dataModel) {
        return new GsonAssembleContext(this.configuration, dataModel);
    }

    public String produce(boolean pretty) {
        NodeProxy rootNodeProxy = this.buildRootNodeProxy();
        if (rootNodeProxy == null) {
            return "";
        }
        return this.gson.toJson((JsonElement)rootNodeProxy.getNode());
    }

    public void output(OutputStream outputStream, Charset charset, boolean pretty) {
        NodeProxy rootNodeProxy = this.buildRootNodeProxy();
        if (rootNodeProxy != null) {
            JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(outputStream, charset));
            this.gson.toJson((JsonElement)rootNodeProxy.getNode(), jsonWriter);
        }
    }
}

