/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring;

import com.github.developframework.resource.Entity;
import com.github.developframework.resource.ResourceDefinition;
import com.github.developframework.resource.spring.SpringDataResourceManager;
import com.github.developframework.resource.spring.cache.CacheType;
import com.github.developframework.resource.spring.cache.HashResourceCacheOperate;
import com.github.developframework.resource.spring.cache.ListResourceCacheOperate;
import com.github.developframework.resource.spring.cache.ResourceCacheOperate;
import com.github.developframework.resource.spring.cache.ValueResourceCacheOperate;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.repository.PagingAndSortingRepository;

public abstract class SpringDataResourceCacheManager<ENTITY extends Entity<ID>, ID extends Serializable, REPOSITORY extends PagingAndSortingRepository<ENTITY, ID>>
extends SpringDataResourceManager<ENTITY, ID, REPOSITORY> {
    @Resource
    protected RedisTemplate<String, ENTITY> redisTemplate;
    protected final String cacheKey;
    protected final Duration timeout;
    protected final CacheType cacheType;
    protected ResourceCacheOperate<ENTITY, ID> cacheOperate;

    public SpringDataResourceCacheManager(REPOSITORY repository, ResourceDefinition<ENTITY> resourceDefinition, String cacheKey, Duration timeout, CacheType cacheType) {
        super(repository, resourceDefinition);
        this.cacheKey = cacheKey;
        this.timeout = timeout;
        this.cacheType = cacheType;
    }

    @PostConstruct
    public void initCacheOperate() {
        switch (this.cacheType) {
            case VALUE: {
                this.cacheOperate = new ValueResourceCacheOperate(this.redisTemplate, this.cacheKey, this.timeout);
                break;
            }
            case HASH: {
                this.cacheOperate = new HashResourceCacheOperate(this.redisTemplate, this.cacheKey, this.timeout);
                break;
            }
            case LIST: {
                this.cacheOperate = new ListResourceCacheOperate(this.redisTemplate, this.cacheKey, this.timeout);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public Optional<ENTITY> add(Object dto) {
        return super.add(dto).map(entity -> {
            if (this.cacheAble(entity)) {
                this.cacheOperate.addCache((Entity)entity);
            }
            return entity;
        });
    }

    @Override
    public Optional<ENTITY> modifyById(ID id, Object dto) {
        return super.modifyById(id, dto).map(entity -> {
            if (this.cacheAble(entity)) {
                this.cacheOperate.refreshCache((Entity)entity);
            } else {
                this.cacheOperate.deleteCache((Entity)entity);
            }
            return entity;
        });
    }

    @Override
    public boolean remove(ENTITY entity) {
        boolean success = super.remove(entity);
        this.cacheOperate.deleteCache(entity);
        return success;
    }

    @Override
    public Optional<ENTITY> removeById(ID id) {
        return super.removeById(id).map(entity -> {
            this.cacheOperate.deleteCache((Entity)entity);
            return entity;
        });
    }

    protected boolean cacheAble(ENTITY entity) {
        return true;
    }
}

