/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring;

import com.github.developframework.resource.Entity;
import com.github.developframework.resource.ResourceDefinition;
import com.github.developframework.resource.ResourceHandler;
import com.github.developframework.resource.Search;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;

public abstract class SpringDataResourceHandler<ENTITY extends Entity<ID>, ID extends Serializable, REPOSITORY extends PagingAndSortingRepository<ENTITY, ID>>
implements ResourceHandler<ENTITY, ID> {
    protected final REPOSITORY repository;
    protected final ResourceDefinition<ENTITY> resourceDefinition;

    public SpringDataResourceHandler(REPOSITORY repository, ResourceDefinition<ENTITY> resourceDefinition) {
        this.repository = repository;
        this.resourceDefinition = resourceDefinition;
    }

    public boolean existsById(ID id) {
        return this.repository.existsById(id);
    }

    public void insert(ENTITY entity) {
        this.repository.save(entity);
    }

    public void insertAll(Collection<ENTITY> entities) {
        this.repository.saveAll(entities);
    }

    public boolean update(ENTITY entity) {
        this.repository.save(entity);
        return true;
    }

    public void deleteById(ID id) {
        this.repository.deleteById(id);
    }

    public void delete(ENTITY entity) {
        this.repository.delete(entity);
    }

    public Optional<ENTITY> queryById(ID id) {
        return this.repository.findById(id);
    }

    public abstract <SEARCH extends Search<ENTITY>> Page<ENTITY> queryPager(Pageable var1, SEARCH var2);

    public abstract <SEARCH extends Search<ENTITY>> List<ENTITY> query(Sort var1, SEARCH var2);
}

